<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Salary
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="salary-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-8-1" data-toggle="tab"><i class="fa fa-list"></i> Salary List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-8-2" data-toggle="tab"><i class="fa fa-edit"></i> Add Salary</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="salary-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab-8-1">
                    	<table class="table table-sm table-bordered table-hover data-table" id="salary-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Grade</th>
		                            <th>Basic</th>
		                            <th>Overtime</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($salarys as $salary): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($salary->grade) ?></td>
		                                <td><?= esc($salary->basic) ?></td>
		                                <td><?= esc($salary->overtime) ?></td>
		                                <td>
		                                    <a href="<?= esc(route('salary.edit', [$salary->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($salary->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($salary->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Salary</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('salary.delete', [$salary->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($salary) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="tab-8-2">
                    	<form action="<?= esc(route('salary.create')) ?>" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Salary Grade<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="grade">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Basic Salary<span class="text-danger">*</span></label>
		                                <input name="basic" type="text" class="form-control" id="basic-salary">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Overtime Rate</label>
		                                <input class="form-control" type="text" name="overtime">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row my-4">
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Allowance 
							                	<a href="javascript:void(0)" class="btn btn-primary btn-xs pull-right" id="add-allowance">
							                		<i class="fa fa-plus font-14"></i>
							                	</a>
							                </h4>
							            </div>
							            <div class="card-body allowance" id="allowance-form">
							                <div class="row" id="allow-row-0">
						                        <div class="col-md-6 col-sm-12">
						                            <div class="form-group">
						                                <input class="form-control allowance-name" type="text" name="allowance0" placeholder="Allowance">
						                            </div>
						                        </div>
						                        <div class="col-md-5 col-sm-10">
						                            <div class="form-group">
						                                <input class="form-control allowance-amount" type="text" name="a_amount0" placeholder="Amount">
						                            </div>
						                        </div>
						                        <div class="col-md-1 col-sm-2">
						                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-allowance" id="add-allowance" data-a_btn="allow-row-0">
								                		<i class="fa fa-times font-14"></i>
								                	</a>
						                        </div>
						                    </div>
							            </div>
							        </div>
		                    	</div>
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Deduction 
							                	<a href="javascript:void(0)" class="btn btn-primary btn-xs pull-right" id="add-deduction">
							                		<i class="fa fa-plus font-14"></i>
							                	</a>
							                </h4>
							            </div>
							            <div class="card-body deduction" id="deduction-form">
							                <div class="row" id="deduct-row-0">
						                        <div class="col-md-6 col-sm-12">
						                            <div class="form-group">
						                                <input class="form-control deduction-name" type="text" name="deduction0" placeholder="Deduction">
						                            </div>
						                        </div>
						                        <div class="col-md-5 col-sm-10">
						                            <div class="form-group">
						                                <input class="form-control deduction-amount" type="text" name="d_amount0" placeholder="Amount">
						                            </div>
						                        </div>
						                        <div class="col-md-1 col-sm-2">
						                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-deduction" id="add-deduction" data-d_btn="deduct-row-0">
								                		<i class="fa fa-times font-14"></i>
								                	</a>
						                        </div>
						                    </div>
							            </div>
							        </div>
							    </div>
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Salary Details</h4>
							            </div>
							            <div class="card-body">
							            	<table class="table table-bordered">
			                                    <tbody>
			                                        <tr>
			                                            <td>Gross Salary</td>
			                                            <td>
			                                            	<input class="form-control" id="gross-salary" type="text" name="deduction" value="0" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Total Allowance</td>
			                                            <td>
			                                            	<input class="form-control" id="total-allowance" type="text" name="deduction" value="0" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Total Deduction</td>
			                                            <td>
			                                            	<input class="form-control" id="total-deduction" type="text" name="deduction" value="0" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Net Salary</td>
			                                            <td>
			                                            	<input class="form-control" id="net-salary" type="text" name="deduction" value="0" disabled>
			                                            </td>
			                                        </tr>
			                                    </tbody>
			                                </table>
							            </div>
							        </div>
							    </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>