<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Salary Payslip
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox invoice">
            <div id="print-content">
                <div class="invoice-header">
                    <div class="row">
                        <div class="col-6">
                            <div class="invoice-logo">
                                <img src="/img/logos/logo-vue.png" height="65px" />
                            </div>
                        </div>
                        <div class="col-6 text-right">
                            <div class="clf" style="margin-bottom:30px;">
                            <?php $date = explode('-', $payslip->payment_date) ?>
                            <?php $payment_date = $date[2].' '.jdmonthname(gregoriantojd($date[1], $date[2], $date[0]), 0).' '.$date[0] ?>
                            <?php $month_of = jdmonthname(gregoriantojd($payslip->month, 1, $payslip->year), 1).' '.$payslip->year ?>
                                <dl class="row pull-right" style="width:250px;"><dt class="col-sm-6">Payslip No:</dt>
                                    <dd class="col-sm-6">#<?= esc($payslip->bill_num) ?></dd><dt class="col-sm-6">Paid Date:</dt>
                                    <dd class="col-sm-6"><?= esc($payment_date) ?></dd><dt class="col-sm-6">Salary For:</dt>
                                    <dd class="col-sm-6"><?= esc($month_of) ?></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div>
                                <div class="m-b-5 font-bold">Invoice from</div>
                                <div>Double Point Marketing</div>
                                <ul class="list-unstyled m-t-10">
                                    <li class="m-b-5">Ikoku, Port Harcourt, Rivers State</li>
                                    <li class="m-b-5">double.point@smartcee.net</li>
                                    <li>+234-0813-580-5584</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-6 text-right">
                            <div>
                                <div class="m-b-5 font-bold">Invoice To</div>
                                <div><?= esc($staff) ?></div>
                                <ul class="list-unstyled m-t-10">
                                    <li class="m-b-5"><?= esc($staff->address) ?></li>
                                    <li class="m-b-5"><?= esc($staff->email) ?></li>
                                    <li><?= esc($staff->phone) ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $salary_details = $staff->salary->salary_details->all() ?>
                    <div class="col-md-6">
                        <h5 class="m-t-10 m-b-10 font-strong">Allowance</h5>
                        <ul class="list-group list-group-bordered">
                            <li class="list-group-item bg-grey-50 font-strong">Name
                                <span class="float-right">Amount(₦)</span>
                            </li>
                            <?php foreach ($salary_details as $detail): ?>
                                <?php if ($detail->type === 'allowance'): ?>
                                    <li class="list-group-item"><?= esc($detail->name) ?>
                                        <span class="float-right"><?= esc($detail->amount) ?></span>
                                    </li>
                                <?php endif ?>
                            <?php endforeach ?>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h5 class="m-t-10 m-b-10 font-strong">Deduction</h5>
                        <ul class="list-group list-group-bordered">
                            <li class="list-group-item bg-grey-50 font-strong">Name
                                <span class="float-right">Amount(₦)</span>
                            </li>
                            <?php foreach ($salary_details as $detail): ?>
                                <?php if ($detail->type === 'deduction'): ?>
                                    <li class="list-group-item"><?= esc($detail->name) ?>
                                        <span class="float-right"><?= esc($detail->amount) ?></span>
                                    </li>
                                <?php endif ?>
                            <?php endforeach ?>
                        </ul>
                    </div>
                </div>
                <table class="table no-border">
                    <thead>
                        <tr>
                            <th></th>
                            <th width="15%"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-right">
                            <td>Basic Salary:</td>
                            <td>₦<?= esc($payslip->basic_salary) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Total Allowance:</td>
                            <td>₦<?= esc($payslip->total_allowance) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Total Deduction:</td>
                            <td>₦<?= esc($payslip->total_deduction) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td class="font-bold font-18">Net Salary:</td>
                            <td class="font-bold font-18">₦<?= esc($payslip->net_salary) ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="text-right">
                <button class="btn btn-info" type="button" onclick="printpage('print-content')"><i class="fa fa-print"></i> Print</button>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>