<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Salary Payroll
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-search"></i> Search Criteria</div>
                 <div class="ibox-tools">
                    <a href="<?= esc(route('salary_allocation.index')) ?>">
                        <button class="btn btn-primary"><i class="fa fa-share-alt"></i>&nbsp;Allocate Salary</button>
                    </a>
                </div>
            </div>
            <div class="ibox-body" id="salary-payroll-filter">
                <form action="<?= esc(route('salary_payroll.index')) ?>" method="GET">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Role<span class="text-danger">*</span></label>
                                        <select name="role" class="form-control custom-select">
                                            <?php if (! empty($currentrole)): ?>
                                                <option value="<?= esc($currentrole->id) ?>"><?= esc($currentrole->name) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($roles as $role): ?>
                                                <option value="<?= esc($role->id) ?>"><?= esc($role->name) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Month<span class="text-danger">*</span></label>
                                        <input type="month" name="month" class="form-control month">
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group pb-4">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary rounded form-control px-5" type="submit" id="salary-payroll-btn">
                                    <i class="fa fa-filter"></i>&nbsp;Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if (! empty($getrole) && ! empty($getmonth)): ?>
<div class="row">
    <div class="col-md-12">
        <form action="" method="POST" id="save-salary-payroll-form" class="salary-payroll-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-plus"></i> Staff Payroll</div>
                </div>
                <div class="ibox-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentrole) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($getmonth) ?></span>
                        </div>
                    </div>
                    <input type="hidden" name="house" id="house" value="<?= esc($gethouse) ?>">
                    <table class="table table-bordered table-hover data-table" id="table" cellspacing="0" width="100%" >
                        <thead class="thead-light">
                            <tr>
                                <th>Photo</th>
                                <th>Name</th>
                                <th>Number</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th>Salary Grade</th>
                                <th>Basic Salary(₦)</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="check-table">
                            <?php foreach ($staffs as $staff): ?>
                            <tr class="table-row">
                                <td><img src="<?= esc(source('image.staff', $staff->photo)) ?>" alt="staff photo" style="height: 30px;"></td>
                                <td><?= esc($staff) ?></td>
                                <td><?= esc($staff->staff_num) ?></td>
                                <td><?= esc($staff->designation) ?></td>
                                <td><?= esc($staff->department) ?></td>
                                <td><?= esc($staff->salary->grade) ?></td>
                                <td><?= esc($staff->salary->basic) ?></td>
                                <?php $month = explode('-', $getmonth) ?>
                                <?php $paid = $staff->payslips->filter(['year' => $month[0], 'and', 'month' => $month[1]])->one() ?>
                                <td>
                                    <?php if ($paid): ?>
                                        <span class="badge badge-success"><?= ucfirst(esc($paid->status)) ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Unpaid</span>
                                    <?php endif ?>
                                </td>
                                <td>
                                    <?php if ($paid): ?>
                                        <a href="<?= esc(route('salary_payslip.index', ['month' => $getmonth, 'id' => $staff->id])) ?>" class="btn btn-default btn-xs m-r-5" title="View" target="_blank">
                                            <i class="fa fa-list-alt font-14"></i> Payslip
                                        </a>
                                    <?php else: ?>
                                        <a href="<?= esc(route('salary_payment.create', [$staff->id, $getmonth])) ?>" class="btn btn-default btn-xs m-r-5" title="View" target="_blank">
                                            <i class="fa fa-credit-card font-14"></i> Payment
                                        </a>
                                    <?php endif ?>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif ?>
<?php endsection() ?>