<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Salary Payment
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-money"></i> Salary Details & Payment</div>
                </div>
                <div class="ibox-body" id="salary-payment-form">
                    <div class="row mb-3">
                        <?php $month = explode('-', $month_year) ?>
                        <div class="col-md-8">
                            <div class="row mb-5">
                                <div class="col-md-12">
                                    <ul class="media-list">
                                        <li class="media">
                                            <a class="media-img" href="javascript:;">
                                                <img src="<?= esc(source('image.staff', $staff->photo)) ?>" alt="staff photo" style="height:180px;" />
                                            </a>
                                            <div class="media-body">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <ul class="list-group list-group-bordered">
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Name</span>
                                                                <span class="float-right"><?= esc($staff) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Number ID</span>
                                                                <span class="float-right"><?= esc($staff->staff_num) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Designation</span>
                                                                <span class="float-right"><?= esc($staff->designation) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Department</span>
                                                                <span class="float-right"><?= esc($staff->department) ?></span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <ul class="list-group list-group-bordered">
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Salary Grade</span>
                                                                <span class="float-right"><?= esc($staff->salary->grade) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Basic Salary(₦)</span>
                                                                <span class="float-right"><?= esc($staff->salary->basic) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Overtime Rate(₦)</span>
                                                                <span class="float-right"><?= esc($staff->salary->overtime) ?></span>
                                                            </li>
                                                            <li class="list-group-item">
                                                                <span class="font-strong">Month-Year</span>
                                                                <span class="float-right"><?= esc(jdmonthname(gregoriantojd($month[1], 1, $month[0]), 1).'-'.$month[0]) ?></span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <?php $basic_salary = $staff->salary->basic ?>
                            <?php $salary_details = $staff->salary->salary_details->all() ?>
                            <div class="row">
                                <div class="col-md-6">
                                <?php $total_allowance = $staff->salary->salary_details->filter(['type' => 'allowance'])->sum('amount') ?>
                                    <h5 class="m-t-10 m-b-10 font-strong">Allowance</h5>
                                    <ul class="list-group list-group-bordered">
                                        <li class="list-group-item bg-grey-50 font-strong">Name
                                            <span class="float-right">Amount(₦)</span>
                                        </li>
                                        <?php foreach ($salary_details as $detail): ?>
                                            <?php if ($detail->type === 'allowance'): ?>
                                                <li class="list-group-item"><?= esc($detail->name) ?>
                                                    <span class="float-right"><?= esc($detail->amount) ?></span>
                                                </li>
                                            <?php endif ?>
                                        <?php endforeach ?>
                                        <li class="list-group-item font-strong">Total
                                            <span class="float-right"><?= esc($total_allowance) ?></span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6 m-b-10">
                                <?php $total_deduction = $staff_dud->salary->salary_details->filter(['type' => 'deduction'])->sum('amount') ?>
                                    <h5 class="m-t-10 m-b-10 font-strong">Deduction</h5>
                                    <ul class="list-group list-group-bordered">
                                        <li class="list-group-item bg-grey-50 font-strong">Name
                                            <span class="float-right">Amount(₦)</span>
                                        </li>
                                        <?php foreach ($salary_details as $detail): ?>
                                            <?php if ($detail->type === 'deduction'): ?>
                                                <li class="list-group-item"><?= esc($detail->name) ?>
                                                    <span class="float-right"><?= esc($detail->amount) ?></span>
                                                </li>
                                            <?php endif ?>
                                        <?php endforeach ?>
                                        <li class="list-group-item font-strong">Total
                                            <span class="float-right"><?= esc($total_deduction) ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <form action="<?= esc(route('salary_payment.create', [$staff->id, $month_year])) ?>" method="POST" class="create-form">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title"><i class="fa fa-credit-card"></i> Payment Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <input type="hidden" name="staff" value="<?= esc($staff->id) ?>">
                                        <input type="hidden" name="month" value="<?= esc($month[1]) ?>">
                                        <input type="hidden" name="year" value="<?= esc($month[0]) ?>">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Basic Salary<span class="text-danger">*</span></label>
                                                    <input class="form-control" type="text" name="basic_salary" value="<?= esc($basic_salary) ?>" readonly>
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Toatal Allowance</label>
                                                    <input class="form-control" type="text" name="total_allowance" value="<?= esc($total_allowance) ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Total Deduction</label>
                                                    <input class="form-control" type="text" name="total_deduction" value="<?= esc($total_deduction) ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Net Salary<span class="text-danger">*</span></label>
                                                    <input class="form-control" type="text" name="net_salary" value="<?= esc(($basic_salary + $total_allowance) - $total_deduction) ?>" readonly>
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Payment Date</label>
                                                    <input class="form-control" type="date" name="payment_date">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Payment Method<span class="text-danger">*</span></label>
                                                    <select name="payment_mode" class="form-control custom-select">
                                                        <option value="">Select</option>
                                                        <?php foreach ($payment_modes as $mode): ?>
                                                        <option value="<?= esc($mode->id) ?>"><?= esc($mode->via) ?></option>
                                                        <?php endforeach ?>
                                                    </select>
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Remark</label>
                                                    <textarea class="form-control" name="remark" rows="2"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <button class="btn btn-primary rounded" type="submit">Make Payment</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
    </div>
</div>
<?php endsection() ?>