<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Salary
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="salary-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('salary.index')) ?>"><i class="fa fa-list"></i> Salary List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Salary</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="salary-form">
                <div class="tab-content">
                    <div class="tab-pane show active" id="edit">
                    	<form action="<?= esc(route('salary.update', [$salary->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Salary Grade<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="grade" value="<?= esc($salary->grade) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Basic Salary<span class="text-danger">*</span></label>
		                                <input name="basic" type="text" class="form-control" id="basic-salary" value="<?= esc($salary->basic) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Overtime Rate</label>
		                                <input class="form-control" type="text" name="overtime" value="<?= esc($salary->overtime) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row my-4">
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Allowance 
							                	<a href="javascript:void(0)" class="btn btn-primary btn-xs pull-right" id="add-allowance">
							                		<i class="fa fa-plus font-14"></i>
							                	</a>
							                </h4>
							            </div>
							            <div class="card-body allowance" id="allowance-form">
							            	<?php $salary_details = $salary->salary_details->all() ?>
							            	<?php if (! empty($salary_details)): ?>
							            		<?php foreach ($salary_details as $salary_detail): ?>
							            			<?php if ($salary_detail->type === 'allowance'): ?>
									            		<div class="row" id="allow-row<?= esc($salary_detail->id) ?>">
									            			<input type="hidden" class="allowance-idx" name="allowance_idx<?= esc($salary_detail->id) ?>" value="<?= esc($salary_detail->id) ?>">
									                        <div class="col-md-6 col-sm-12">
									                            <div class="form-group">
									                                <input class="form-control allowance-name" type="text" name="allowance0<?= esc($salary_detail->id) ?>" placeholder="Allowance" value="<?= esc($salary_detail->name) ?>">
									                            </div>
									                        </div>
									                        <div class="col-md-5 col-sm-10">
									                            <div class="form-group">
									                                <input class="form-control allowance-amount" type="text" name="a_amount0<?= esc($salary_detail->id) ?>" placeholder="Amount" value="<?= esc($salary_detail->amount) ?>">
									                            </div>
									                        </div>
									                        <div class="col-md-1 col-sm-2">
									                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-allowance" data-a_btn="allow-row<?= esc($salary_detail->id) ?>">
											                		<i class="fa fa-times font-14"></i>
											                	</a>
									                        </div>
									                    </div>
							                    	<?php endif ?>
							            		<?php endforeach ?>
							            	<?php else: ?>
							            		<div class="row" id="allow-row-0">
							                        <div class="col-md-6 col-sm-12">
							                            <div class="form-group">
							                                <input class="form-control allowance-name" type="text" name="allowance0" placeholder="Allowance">
							                            </div>
							                        </div>
							                        <div class="col-md-5 col-sm-10">
							                            <div class="form-group">
							                                <input class="form-control allowance-amount" type="text" name="a_amount0" placeholder="Amount">
							                            </div>
							                        </div>
							                        <div class="col-md-1 col-sm-2">
							                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-allowance" data-a_btn="allow-row-0">
									                		<i class="fa fa-times font-14"></i>
									                	</a>
							                        </div>
							                    </div>
							            	<?php endif ?>
							            </div>
							        </div>
		                    	</div>
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Deduction 
							                	<a href="javascript:void(0)" class="btn btn-primary btn-xs pull-right" id="add-deduction">
							                		<i class="fa fa-plus font-14"></i>
							                	</a>
							                </h4>
							            </div>
							            <div class="card-body deduction" id="deduction-form">
							            	<?php $salary_details = $deduct->salary_details->all() ?>
							            	<?php if (! empty($salary_details)): ?>
							            		<?php foreach ($salary_details as $salary_detail): ?>
							            			<?php if ($salary_detail->type === 'deduction'): ?>
							            				<div class="row" id="deduct-row<?= esc($salary_detail->id) ?>">
							            					<input type="hidden" class="deduction-idx" name="deduction_idx<?= esc($salary_detail->id) ?>" value="<?= esc($salary_detail->id) ?>">
									                        <div class="col-md-6 col-sm-12">
									                            <div class="form-group">
									                                <input class="form-control deduction-name" type="text" name="deduction0<?= esc($salary_detail->id) ?>" placeholder="Deduction" value="<?= esc($salary_detail->name) ?>">
									                            </div>
									                        </div>
									                        <div class="col-md-5 col-sm-10">
									                            <div class="form-group">
									                                <input class="form-control deduction-amount" type="text" name="d_amount0<?= esc($salary_detail->id) ?>" placeholder="Amount" value="<?= esc($salary_detail->amount) ?>">
									                            </div>
									                        </div>
									                        <div class="col-md-1 col-sm-2">
									                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-deduction" data-d_btn="deduct-row<?= esc($salary_detail->id) ?>">
											                		<i class="fa fa-times font-14"></i>
											                	</a>
									                        </div>
									                    </div>
							            			<?php endif ?>
							            		<?php endforeach ?>
							            	<?php else: ?>
							            		<div class="row" id="deduct-row-0">
							                        <div class="col-md-6 col-sm-12">
							                            <div class="form-group">
							                                <input class="form-control deduction-name" type="text" name="deduction0" placeholder="Deduction">
							                            </div>
							                        </div>
							                        <div class="col-md-5 col-sm-10">
							                            <div class="form-group">
							                                <input class="form-control deduction-amount" type="text" name="d_amount0" placeholder="Amount">
							                            </div>
							                        </div>
							                        <div class="col-md-1 col-sm-2">
							                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs pull-right remove-deduction" data-d_btn="deduct-row-0">
								                		<i class="fa fa-times font-14"></i>
								                	</a>
							                        </div>
							                    </div>
							            	<?php endif ?>
							            </div>
							        </div>
							    </div>
		                    	<div class="col-md-4">
		                    		<div class="card">
							            <div class="card-header">
							                <h4 class="card-title">Salary Details</h4>
							            </div>
							            <div class="card-body">
							            	<table class="table table-bordered">
			                                    <tbody>
			                                        <tr>
			                                            <td>Basic Salary</td>
			                                            <td>
			                                            	<input class="form-control" id="gross-salary" type="text" name="deduction" value="<?= esc($salary->basic) ?>" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Total Allowance</td>
			                                            <td>
			                                            	<input class="form-control" id="total-allowance" type="text" name="deduction" value="<?= esc($total_allowance) ?>" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Total Deduction</td>
			                                            <td>
			                                            	<input class="form-control" id="total-deduction" type="text" name="deduction" value="<?= esc($total_deduction) ?>" disabled>
			                                            </td>
			                                        </tr>
			                                        <tr>
			                                            <td>Net Salary</td>
			                                            <td>
			                                            	<input class="form-control" id="net-salary" type="text" name="deduction" value="<?= esc($net_salary) ?>" disabled>
			                                            </td>
			                                        </tr>
			                                    </tbody>
			                                </table>
							            </div>
							        </div>
							    </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>