<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Salary Allocation
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-search"></i> Search Criteria</div>
            </div>
            <div class="ibox-body" id="salary-allocation-filter">
                <form action="<?= esc(route('salary_allocation.index')) ?>" method="GET">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Role<span class="text-danger">*</span></label>
                                        <select name="role" class="form-control custom-select">
                                            <?php if (! empty($currentrole)): ?>
                                                <option value="<?= esc($currentrole->id) ?>"><?= esc($currentrole->name) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($roles as $role): ?>
                                                <option value="<?= esc($role->id) ?>"><?= esc($role->name) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Salary Template<span class="text-danger">*</span></label>
                                        <select name="salary" class="form-control custom-select ksection">
                                            <?php if (! empty($currentsalary)): ?>
                                                <option value="<?= esc($currentsalary->id) ?>"><?= esc($currentsalary->grade) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($salarys as $salary): ?>
                                            <option value="<?= esc($salary->id) ?>"><?= esc($salary) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group pb-4">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary rounded form-control px-5" type="submit" id="salary-allocation-btn">
                                    <i class="fa fa-filter"></i>&nbsp;Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if (! empty($getrole) && ! empty($getsalary)): ?>
<div class="row">
    <div class="col-md-12">
        <form action="<?= esc(route('salary_allocation.create')) ?>" method="POST" id="save-salary-allocation-form" class="salary-allocation-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-share-alt"></i> Salary Allocation</div>
                    <div class="ibox-tools">
                        <button class="btn btn-primary" type="submit" id="add-members">
                            <i class="fa fa-save"></i>&nbsp;Save Allocation
                        </button>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentrole) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5">Salary Grade<?= esc($currentsalary) ?></span>
                        </div>
                    </div>
                    <input type="hidden" name="salary" id="salary" value="<?= esc($getsalary) ?>">
                    <table class="table table-bordered table-hover data-table" id="table" cellspacing="0" width="100%" >
                        <thead class="thead-light">
                            <tr>
                                <th>Photo</th>
                                <th>Name</th>
                                <th>Number</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th> 
                                    <label class="ui-checkbox ui-checkbox-success">
                                        <input type="checkbox" name="check_all" id="check-all">
                                        <span class="input-span"></span> <b>Check All</b>
                                    </label>
                                </th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="check-table">
                            <?php foreach ($staffs as $staff): ?>
                            <tr class="table-row">
                                <td><img src="<?= esc(source('image.staff', $staff->photo)) ?>" alt="staff photo" style="height: 30px;"></td>
                                <td>
                                    <?= esc($staff) ?>
                                    <input type="hidden" class="staff" value="<?= esc($staff->id) ?>" name="staff<?= esc(counter()) ?>">
                                </td>
                                <td><?= esc($staff->staff_num) ?></td>
                                <td><?= esc($staff->designation) ?></td>
                                <td><?= esc($staff->department) ?></td>
                                <td>
                                    <label class="ui-checkbox ui-checkbox-success">
                                        <input type="checkbox" name="staff_check<?= esc(counter()) ?>" class="row-check" <?php if ($staff->salary == $currentsalary): ?>checked<?php endif ?>>
                                        <span class="input-span"></span> 
                                    </label>
                                </td>
                                <td>
                                    <a href="<?= esc(route('staff_profile.detail', ['id' => $staff->id])) ?>" class="btn btn-default btn-xs m-r-5" title="View">
                                        <i class="fa fa-bars font-14"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif ?>
<?php endsection() ?>