<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Profile
<?php endsection() ?>
<?php section('content') ?>
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-3 col-md-4">
            <div class="ibox">
                <div class="ibox-body">
                    <div class="text-center">
                        <div class="m-t-20">
                            <img class="img-circle" src="<?= esc(source('image.staff', $staff->photo)) ?>" />
                        </div>
                        <h5 class="font-strong m-b-10 m-t-10"><?= esc($staff) ?></h5>
                        <div class="m-b-20 text-muted"><?= esc($staff->role) ?></div>
                    </div>
                    <ul class="list-group list-group-bordered">
                        <li class="list-group-item">
                            <span class="font-strong">Staff ID</span>
                            <span class="float-right"><?= esc($staff->staff_num) ?></span>
                        </li>
                        <li class="list-group-item">
                            <span class="font-strong">Designation</span>
                            <span class="float-right"><?= esc($staff->designation) ?></span>
                        </li>
                        <li class="list-group-item">
                            <span class="font-strong">Department</span>
                            <span class="float-right"><?= esc($staff->department) ?></span>
                        </li>
                        <li class="list-group-item">
                            <span class="font-strong">Joining Date</span>
                            <span class="float-right"><?= esc($staff->join_date) ?></span>
                        </li>
                        <li class="list-group-item">
                            <span class="font-strong">Appointment</span>
                            <span class="float-right"><?= esc($staff->appointment) ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-9 col-md-8">
            <div class="ibox">
                <div class="ibox-body">
                    <ul class="nav nav-tabs tabs-line">
                        <li class="nav-item">
                            <a class="nav-link active" href="#tab-1" data-toggle="tab"><i class="ti-user"></i> Profile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab-2" data-toggle="tab"><i class="ti-wallet"></i> Payroll</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab-3" data-toggle="tab"><i class="ti-calendar"></i> Leaves</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab-4" data-toggle="tab"><i class="ti-timer"></i> Attendance</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab-5" data-toggle="tab"><i class="ti-folder"></i> Documents</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab-6" data-toggle="tab"><i class="ti-announcement"></i> Social</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab-1">
                            <div class="row mb-4">
                                <div class="col-md-6" style="border-right: 1px solid #eee;">
                                    <h5 class="text-info m-b-20 m-t-10"><i class="fa fa-user-md"></i> Bio Data</h5>
                                    <ul class="list-group list-group-full list-group-divider">
                                        <li class="list-group-item">
                                            <span class="font-strong">Date Of Birth</span>
                                            <?php if (! empty($staff->dob)): ?>
                                                <?php $dob = explode('-', $staff->dob) ?>
                                                <?php $staff_dob = $dob[2].' '.jdmonthname(gregoriantojd($dob[1], $dob[2], $dob[0]), 0).' '.$dob[0] ?>
                                                <span class="float-right"><?= esc($staff_dob) ?></span>
                                            <?php endif ?>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Gender</span>
                                            <span class="pull-right"><?= ucfirst(esc($staff->gender)) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Marital Status</span>
                                            <span class="pull-right"><?= esc($staff->status) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Religion</span>
                                            <span class="pull-right"><?= esc($staff->religion) ?></span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h5 class="text-info m-b-20 m-t-10"><i class="fa fa-commenting-o"></i> Contact</h5>
                                    <ul class="list-group list-group-full list-group-divider">
                                        <li class="list-group-item">
                                            <span class="font-strong">Email</span>
                                            <span class="pull-right"><?= esc($staff->email) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Phone</span>
                                            <span class="pull-right"><?= esc($staff->phone) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Emergency Contact</span>
                                            <span class="pull-right"><?= esc($staff->alt_contact) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong"><?php if (! empty($staff->social_num)): ?><?= ucwords(esc($staff->social_num->type)) ?><?php endif ?></span>
                                            <span class="pull-right"><?php if (! empty($staff->social_num)): ?><?= esc($staff->social_num->number) ?><?php endif ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-md-6" style="border-right: 1px solid #eee;">
                                    <h5 class="text-info m-b-20 m-t-10"><i class="fa fa-map-marker"></i> Address</h5>
                                    <ul class="list-group list-group-full list-group-divider">
                                        <li class="list-group-item">
                                            <span class="font-strong">Country</span>
                                            <span class="pull-right"><?= esc($staff->country) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">State/Province</span>
                                            <span class="pull-right"><?= esc($staff->state) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">City</span>
                                            <span class="pull-right"><?= esc($staff->city) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Address</span>
                                            <span class="pull-right"><?= esc($staff->address) ?></span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h5 class="text-info m-b-20 m-t-10"><i class="fa fa-money"></i> Bank Account</h5>
                                    <ul class="list-group list-group-full list-group-divider">
                                        <li class="list-group-item">
                                            <span class="font-strong">Name</span>
                                            <span class="pull-right"><?= esc($staff->account->name) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Number</span>
                                            <span class="pull-right"><?= esc($staff->account->number) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Bank</span>
                                            <span class="pull-right"><?= esc($staff->account->bank) ?></span>
                                        </li>
                                        <li class="list-group-item" style="border-top:1px solid #e1eaec;">
                                            <span class="font-strong">Branch</span>
                                            <span class="pull-right"><?= esc($staff->account->branch) ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tab-2">
                            <div id="accordion">
                                <?php $payslips = $staff->payslips->all() ?>
                                <?php foreach (range(substr($staff->join_date, 0, 4), date("Y")) as $year): ?>
                                <?php $count = counter() ?>
                                <div class="card m-b-10">
                                    <a class="card-link" data-toggle="collapse" href="#collapse<?= esc($count) ?>">
                                        <div class="card-header"><?= esc($year) ?></div>
                                    </a>
                                    <div id="collapse<?= esc($count) ?>" class="collapse <?php if ($year == date('Y')): ?>show<?php endif ?>" data-parent="#accordion">
                                        <div class="card-body">
                                            <table class="table table-bordered table-hover table-sm table-responsive-sm" cellspacing="0" width="100%" >
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Payslip No (#)</th>
                                                        <th>Month-Year</th>
                                                        <th>Date</th>
                                                        <th>Mode</th>
                                                        <th>Status</th>
                                                        <th>Net Salary(#)</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="check-table">
                                                    <?php $sy = 0 ?>
                                                    <?php foreach ($payslips as $payslip): ?>
                                                        <?php if ($payslip->year == $year): ?>
                                                        <?php ++$sy ?>
                                                        <tr class="table-row">
                                                            <td><?= esc($payslip->bill_num) ?></td>
                                                            <td><?= esc($payslip->month) ?>-<?= esc($payslip->year) ?></td>
                                                            <td><?= esc($payslip->payment_date) ?></td>
                                                            <td><?= esc($payslip->payment_mode) ?></td>
                                                            <td>
                                                                <?php if ($payslip->status === 'paid'): ?>
                                                                    <span class="badge badge-success"><?= ucfirst(esc($payslip->status)) ?></span>
                                                                <?php else: ?>
                                                                    <span class="badge badge-danger">Unpaid</span>
                                                                <?php endif ?>
                                                            </td>
                                                            <td><?= esc($payslip->net_salary) ?></td>
                                                            <td>
                                                                <a href="<?= esc(route('salary_payslip.index', ['month' => "$payslip->year-$payslip->month", 'id' => $staff->id])) ?>" class="btn btn-default btn-xs m-r-5" title="View" target="_blank">
                                                                    <i class="fa fa-list-alt font-14"></i> Payslip
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php endif ?>
                                                    <?php endforeach ?>
                                                    <?php if ($sy == 0): ?>
                                                        <tr><td colspan="7" class="text-danger text-center">No Record</td></tr>
                                                    <?php endif ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach ?>
                            </div>         
                        </div>
                        <div class="tab-pane fade" id="tab-3">
                            <table class="table table-sm table-bordered table-hover table-responsive-sm data-table" cellspacing="0" width="100%">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Type</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Duration</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($staff->leaves->all() as $leave): ?>
                                        <tr>
                                            <td><?= esc(counter()) ?></td>
                                            <td><?= esc($leave->leave_type) ?></td>
                                            <td><?= esc($leave->from) ?></td>
                                            <td><?= esc($leave->to) ?></td>
                                            <td><?= esc($leave->leave_type->duration) ?></td>
                                            <td>
                                                <?php if ($leave->status === 'declined'): ?>
                                                    <span class="badge badge-danger"><?= ucfirst(esc($leave->status)) ?></span>
                                                <?php elseif ($leave->status === 'pending'): ?>
                                                    <span class="badge badge-warning"><?= ucfirst(esc($leave->status)) ?></span>
                                                <?php elseif ($leave->status === 'approved'): ?>
                                                    <span class="badge badge-success"><?= ucfirst(esc($leave->status)) ?></span>
                                                <?php endif ?>
                                            </td>
                                            <td><?= esc($leave->reason) ?></td>
                                            <td>
                                                <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($leave->id) ?>" title="View"><i class="fa fa-eye font-14"></i></button>
                                            </td>
                                            <div class="modal fade" id="subj-del-<?= esc($leave->id) ?>" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content rounded">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Leave Application</h4>
                                                            <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form action="<?= esc(route('leave.delete', [$leave->id])) ?>?_method=DELETE" method="POST" class="delete-form">
                                                                <div>
                                                                    <h2 class="text-warning display-2 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
                                                                    <h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($leave) ?></em>"?</h4>
                                                                    <p class="text-center">You may not be able to reverse this action.</p>
                                                                </div>
                                                                <div class="form-group d-flex justify-content-center mt-4">
                                                                    <button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
                                                                    <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="tab-4">
                            <p>
                                <span class="badge badge-success m-r-5 m-b-5">PRESENT</span>
                                <span class="badge badge-info m-r-5 m-b-5">HOLIDAY</span>
                                <span class="badge badge-warning m-r-5 m-b-5">LATE</span>
                                <span class="badge badge-danger m-r-5 m-b-5">ABSENT</span>
                                <span class="badge badge-default m-r-5 m-b-5">VACATION</span>
                                <span class="badge badge-primary m-b-5">WEEKEND</span>
                            </p>
                            <table class="table table-hover table-bordered table-responsive-sm table-sm text-center">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>01</th>
                                        <th>02</th>
                                        <th>03</th>
                                        <th>04</th>
                                        <th>05</th>
                                        <th>06</th>
                                        <th>07</th>
                                        <th>08</th>
                                        <th>09</th>
                                        <th>10</th>
                                        <th>11</th>
                                        <th>12</th>
                                        <th>13</th>
                                        <th>14</th>
                                        <th>15</th>
                                        <th>16</th>
                                        <th>17</th>
                                        <th>18</th>
                                        <th>19</th>
                                        <th>20</th>
                                        <th>21</th>
                                        <th>22</th>
                                        <th>23</th>
                                        <th>24</th>
                                        <th>25</th>
                                        <th>26</th>
                                        <th>27</th>
                                        <th>28</th>
                                        <th>29</th>
                                        <th>30</th>
                                        <th>31</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $attendances = array_column(prettify($staff->attendances->all()), 'status', 'date') ?>
                                    <?php foreach ($months as $month => $m): ?>
                                        <tr>
                                            <!-- 01 -->
                                            <th><?= esc($m) ?></th>
                                            <?php if (isset($attendances["2023-$month-01"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-01"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-01"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 01, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 01, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 02 -->
                                            <?php if (isset($attendances["2023-$month-02"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-02"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-02"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 02, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 02, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 03 -->
                                            <?php if (isset($attendances["2023-$month-03"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-03"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-03"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 03, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 03, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 04 -->
                                            <?php if (isset($attendances["2023-$month-04"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-04"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-04"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 04, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 04, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 05 -->
                                            <?php if (isset($attendances["2023-$month-05"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-05"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-05"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 05, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 05, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 06 -->
                                            <?php if (isset($attendances["2023-$month-06"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-06"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-06"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 06, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 06, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 07 -->
                                            <?php if (isset($attendances["2023-$month-07"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-07"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-07"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 07, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 07, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 08 -->
                                            <?php if (isset($attendances["2023-$month-08"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-08"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-08"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 0, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 0, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 09 -->
                                            <?php if (isset($attendances["2023-$month-09"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-09"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-09"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 9, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 9, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 10 -->
                                            <?php if (isset($attendances["2023-$month-10"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-10"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-10"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 10, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 10, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 11 -->
                                            <?php if (isset($attendances["2023-$month-11"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-11"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-11"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 11, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 11, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 12 -->
                                            <?php if (isset($attendances["2023-$month-12"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-12"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-12"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 12, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 12, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 13 -->
                                            <?php if (isset($attendances["2023-$month-13"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-13"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-13"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 13, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 13, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 14 -->
                                            <?php if (isset($attendances["2023-$month-14"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-14"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-14"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 14, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 14, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 15 -->
                                            <?php if (isset($attendances["2023-$month-15"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-15"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-15"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 15, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 15, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 16 -->
                                            <?php if (isset($attendances["2023-$month-16"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-16"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-16"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 16, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 16, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 17 -->
                                            <?php if (isset($attendances["2023-$month-17"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-17"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-17"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 17, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 17, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 18 -->
                                            <?php if (isset($attendances["2023-$month-18"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-18"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-18"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 18, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 18, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 19 -->
                                            <?php if (isset($attendances["2023-$month-19"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-19"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-19"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 19, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 19, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 20 -->
                                            <?php if (isset($attendances["2023-$month-20"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-20"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-20"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 20, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 20, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 21 -->
                                            <?php if (isset($attendances["2023-$month-21"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-21"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-21"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 21, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 21, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 22 -->
                                            <?php if (isset($attendances["2023-$month-22"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-22"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-22"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 22, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 22, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 23 -->
                                            <?php if (isset($attendances["2023-$month-23"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-23"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-23"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 23, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 23, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 24 -->
                                            <?php if (isset($attendances["2023-$month-24"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-24"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-24"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 24, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 24, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 25 -->
                                            <?php if (isset($attendances["2023-$month-25"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-25"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-25"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 25, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 25, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 26 -->
                                            <?php if (isset($attendances["2023-$month-26"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-26"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-26"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 26, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 26, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 27 -->
                                            <?php if (isset($attendances["2023-$month-27"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-27"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-27"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 27, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 27, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 28 -->
                                            <?php if (isset($attendances["2023-$month-28"])): ?>
                                            <td class="<?= esc($bgc[$attendances["2023-$month-28"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-28"])[0]) ?></td>
                                            <?php elseif (jddayofweek(gregoriantojd($month, 28, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 28, 2023), 1) == 'Sunday'): ?>
                                            <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                            <?php else: ?>
                                            <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                            <?php endif ?>
                                            <!-- 29 -->
                                            <?php if ($m == 'Feb' && ! leap_year(2023)): ?>
                                                <td class="bg-silver-50">NIL</td>
                                            <?php else: ?>
                                                <?php if (isset($attendances["2023-$month-29"])): ?>
                                                <td class="<?= esc($bgc[$attendances["2023-$month-29"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-29"])[0]) ?></td>
                                                <?php elseif (jddayofweek(gregoriantojd($month, 29, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 29, 2023), 1) == 'Sunday'): ?>
                                                <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                                <?php else: ?>
                                                <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                                <?php endif ?>
                                            <?php endif ?>
                                            <!-- 30 -->
                                            <?php if ($m == 'Feb'): ?>
                                                <td class="bg-silver-50">NIL</td>
                                            <?php else: ?>
                                                <?php if (isset($attendances["2023-$month-30"])): ?>
                                                <td class="<?= esc($bgc[$attendances["2023-$month-30"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-30"])[0]) ?></td>
                                                <?php elseif (jddayofweek(gregoriantojd($month, 30, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 30, 2023), 1) == 'Sunday'): ?>
                                                <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                                <?php else: ?>
                                                <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                                <?php endif ?>
                                            <?php endif ?>
                                            <!-- 31 -->
                                            <?php if ($m == 'Apr' || $m == 'Jun' || $m == 'Sep' || $m == 'Nov' || $m == 'Feb'): ?>
                                                <td class="bg-silver-50">NIL</td>
                                            <?php else: ?>
                                                <?php if (isset($attendances["2023-$month-31"])): ?>
                                                <td class="<?= esc($bgc[$attendances["2023-$month-31"]]) ?>"><?= esc(ucfirst($attendances["2023-$month-31"])[0]) ?></td>
                                                <?php elseif (jddayofweek(gregoriantojd($month, 31, 2023), 1) == 'Saturday'|| jddayofweek(gregoriantojd($month, 31, 2023), 1) == 'Sunday'): ?>
                                                <td class="<?= esc($bgc['weekend']) ?>">W</td>
                                                <?php else: ?>
                                                <td class="<?= esc($bgc['free']) ?>">N/A</td>
                                                <?php endif ?>
                                            <?php endif ?>
                                        </tr>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="tab-5">
                            <div class="m-b-20">
                                <button class="btn btn-primary btn-sm" type="button" data-toggle="modal" data-target="#upload-doc-modal">
                                    <i class="fa fa-upload"></i>&nbsp;Upload
                                </button>
                            </div>
                            <table class="table table-striped table-hover table-bordered table-sm table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th>S/N</th>
                                        <th>Title</th>
                                        <th>Type</th>
                                        <th>Remark</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $sd = 0 ?>
                                <?php foreach ($staff->documents->all() as $doc): ?>
                                    <tr>
                                        <th><?= ++$sd ?></th>
                                        <td><?= $doc->title ?></td>
                                        <td><?= $doc->type ?></td>
                                        <td><?= $doc->note ?></td>
                                        <?php $doc_date = date_create(esc($doc->created_at)) ?>
                                        <td><?= date_format($doc_date, "d M Y") ?></td>
                                        <td>
                                            <a href="<?= esc(source('file.staff_document', $doc->path)) ?>" class="btn btn-default btn-xs m-r-5" title="Download"><i class="fa fa-download font-14" download></i></a>
                                            <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#edit-doc-<?= esc($doc->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button>
                                            <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#doc-del-<?= esc($doc->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="doc-del-<?= esc($doc->id) ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content rounded">
                                                <div class="modal-header">
                                                    <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Document</h4>
                                                    <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                                </div>
                                                <div class="modal-body staff-doc">
                                                    <form action="<?= esc(route('staff_document.delete', [$doc->id])) ?>?_method=DELETE" method="POST" class="delete-form">
                                                        <div>
                                                            <h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
                                                            <h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($doc) ?></em>"?</h4>
                                                            <p class="text-center">You may not be able to reverse this action.</p>
                                                        </div>
                                                        <div class="form-group d-flex justify-content-center mt-4">
                                                            <button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
                                                            <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal fade" id="edit-doc-<?= esc($doc->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content rounded">
                                                <div class="modal-header">
                                                    <h4 class="modal-title"><i class="fa fa-upload"></i> Upload Document</h4>
                                                    <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                                </div>
                                                <div class="modal-body staff-doc">
                                                    <form action="<?= esc(route('staff_document.update', [$doc->id])) ?>?_method=PUT" method="POST" class="upload-doc-form">
                                                        <div class="row">
                                                            <div class="col-md-6 kn">
                                                                <div class="form-group">
                                                                    <label>Title<span class="text-danger">*</span></label>
                                                                    <input class="form-control" type="text" name="title" value="<?= esc($doc->title) ?>">
                                                                    <div class="invalid-feedback"></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label>File Type<span class="text-danger">*</span></label>
                                                                    <input type="text" name="type" class="form-control" value="<?= esc($doc->type) ?>">
                                                                    <div class="invalid-feedback"></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6 kn">
                                                                <div class="form-group">
                                                                    <label>Document<span class="text-danger">*</span></label>
                                                                    <input class="dropify" type="file" name="path" data-height="80" data-max-file-size="2M" data-default-file="<?= esc(source('file.staff_document', $doc->path)) ?>">
                                                                    <div class="invalid-feedback"></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label>Remark</label>
                                                                    <textarea class="form-control" name="note" rows="4"><?= esc($doc->note) ?></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                                                            <button class="btn btn-primary rounded" type="submit">Upload</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach ?>
                                <?php if ($sd == 0): ?>
                                    <tr><td colspan="6" class="text-danger text-center">No Record</td></tr>
                                <?php endif ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="tab-pane fade" id="tab-6">
                            <div class="m-b-20">
                                <button class="btn btn-primary btn-sm" type="button" data-toggle="modal" data-target="#social-handle-modal">
                                    <i class="fa fa-chain"></i>&nbsp;Add Link
                                </button>
                            </div>
                            <table class="table table-striped table-hover table-sm table-bordered table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th>S/N</th>
                                        <th>Handle</th>
                                        <th>Link</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $ssh = 0 ?>
                                    <?php foreach ($staff->handles->all() as $handle): ?>
                                        <tr>
                                            <th><?= ++$ssh ?></th>
                                            <td><?= esc($handle->social) ?></td>
                                            <td><?= esc($handle->link) ?></td>
                                            <td>
                                                <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#social-edit-<?= esc($handle->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button>
                                                <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#social-del-<?= esc($handle->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                            </td>
                                        </tr>
                                        <div class="modal fade" id="social-del-<?= esc($handle->id) ?>" tabindex="-1" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content rounded">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Social Handle</h4>
                                                        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                                    </div>
                                                    <div class="modal-body ss-handle-edit">
                                                        <form action="<?= esc(route('staff_social.delete', [$handle->id])) ?>?_method=DELETE" method="POST" class="delete-form">
                                                            <div>
                                                                <h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
                                                                <h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($handle->social) ?></em>"?</h4>
                                                                <p class="text-center">You may not be able to reverse this action.</p>
                                                            </div>
                                                            <div class="form-group d-flex justify-content-center mt-4">
                                                                <button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
                                                                <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal fade" id="social-edit-<?= esc($handle->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content rounded">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><i class="fa fa-chain"></i> Social Handle</h4>
                                                        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                                    </div>
                                                    <div class="modal-body ss-handle-edit">
                                                        <form action="<?= esc(route('staff_social.update', [$handle->id])) ?>?_method=PUT" method="POST" class="update-form">
                                                            <div class="row">
                                                                <div class="col-md-12 kn">
                                                                    <div class="form-group">
                                                                        <label>Handle<span class="text-danger">*</span></label>
                                                                        <select class="form-control custom-select" name="social">
                                                                            <option value="<?= esc($handle->social->id) ?>" selected><?= esc($handle->social) ?>
                                                                            <?php foreach ($socials as $social): ?>
                                                                                <option value="<?= esc($social->id) ?>"><?= esc($social) ?></option>
                                                                            <?php endforeach ?>
                                                                        </select>
                                                                        <div class="invalid-feedback"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label>Link<span class="text-danger">*</span></label>
                                                                        <input type="text" name="link" class="form-control" value="<?= esc($handle->link) ?>">
                                                                        <div class="invalid-feedback"></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                                                                <button class="btn btn-primary rounded" type="submit">Upload</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="upload-doc-modal" data-backdrop="static" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content rounded">
            <div class="modal-header">
                <h4 class="modal-title"><i class="fa fa-upload"></i> Upload Document</h4>
                <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <div class="modal-body staff-doc">
                <form action="<?= esc(route('staff_document.create', [$staff->id])) ?>" method="POST" class="upload-doc-form">
                    <div class="row">
                        <div class="col-md-6 kn">
                            <div class="form-group">
                                <label>Title<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="title">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>File Type<span class="text-danger">*</span></label>
                                <input type="text" name="type" class="form-control">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6 kn">
                            <div class="form-group">
                                <label>Document<span class="text-danger">*</span></label>
                                <input class="dropify" type="file" name="path" data-height="80" data-max-file-size="2M">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Remark</label>
                                <textarea class="form-control" name="note" rows="4"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                        <button class="btn btn-primary rounded" type="submit">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="social-handle-modal" data-backdrop="static" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content rounded">
            <div class="modal-header">
                <h4 class="modal-title"><i class="fa fa-chain"></i> Social Handle</h4>
                <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <div class="modal-body" id="ss-handle-form">
                <form action="<?= esc(route('staff_social.create')) ?>" method="POST" class="create-form">
                    <?= input_type('staff', $staff->id) ?>
                    <div class="row">
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Handle<span class="text-danger">*</span></label>
                                <select class="form-control custom-select" name="social">
                                    <option value="" selected>Select</option>
                                    <?php foreach ($socials as $social): ?>
                                        <option value="<?= esc($social->id) ?>"><?= esc($social) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Link<span class="text-danger">*</span></label>
                                <input type="text" name="link" class="form-control">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                        <button class="btn btn-primary rounded" type="submit">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>