<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Leave Requests
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="leave-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('leave.index')) ?>"><i class="fa fa-list"></i> Leave Requests</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Request</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="leave-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
                    	<form action="<?= esc(route('leave.update', [$leave->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Role</label>
		                                <select name="role" data-url="<?= esc(route('staff.select')) ?>?role_id=" class="form-control custom-select role-field">
		                                	<option value="<?= esc($leave->staff->role->id) ?>" selected><?= esc($leave->staff->role) ?></option>
		                                	<option value="">Select</option>
		                                	<?php foreach ($roles as $role): ?>
		                                		<option value="<?= esc($role->id) ?>"><?= esc($role) ?></option>
		                                	<?php endforeach ?>
		                                </select>
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Applicant</label>
		                                <select name="staff" class="form-control custom-select rstaff">
		                                	<option value="<?= esc($leave->staff->id) ?>" selected=""><?= esc($leave->staff) ?></option>
	                                        <option value="">Select Role First</option>
	                                    </select>
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave Type</label>
		                                <select name="leave_type" class="form-control custom-select">
		                                	<option value="<?= esc($leave->leave_type->id) ?>" selected><?= esc($leave->leave_type) ?></option>
		                                	<option value="">Select</option>
		                                	<?php foreach ($leave_types as $leave_type): ?>
		                                		<option value="<?= esc($leave_type->id) ?>"><?= esc($leave_type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave From</label>
		                                <input class="form-control" type="date" name="from" value="<?= esc($leave->from) ?>">
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave To</label>
	                                    <input class="form-control" type="date" name="to" value="<?= esc($leave->to) ?>">
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>File</label>
	                                    <input class="dropify" type="file" name="file" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('file.leave', $leave->file)) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Reason</label>
		                                <textarea class="form-control" name="reason"><?= esc($leave->reason) ?></textarea>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <textarea class="form-control" name="remark"><?= esc($leave->remark) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>