<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
My Leave Requests
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="leave-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> My Leave Requests</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Request</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="leave-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="leave-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Type</th>
		                            <th>From</th>
		                            <th>To</th>
		                            <th>Status</th>
		                            <th>Reason</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($leaves as $leave): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($leave->leave_type) ?></td>
		                                <td><?= esc($leave->from) ?></td>
		                                <td><?= esc($leave->to) ?></td>
		                                <td><?= esc($leave->status) ?></td>
		                                <td><?= esc($leave->reason) ?></td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($leave->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('leave.apply.edit', [$leave->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($leave->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($leave->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Leave Application</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('leave.delete', [$leave->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($leave) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('leave.create')) ?>" method="POST" class="save-edit-form">
		                    <div class="row">
		                    	<input type="hidden" name="staff" value="<?= esc(auth_user()->id) ?>">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave Type<span class="text-danger">*</span></label>
		                                <select name="leave_type" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($leave_types as $leave_type): ?>
		                                		<option value="<?= esc($leave_type->id) ?>"><?= esc($leave_type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave From<span class="text-danger">*</span></label>
		                                <input class="form-control" type="date" name="from">
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Leave To<span class="text-danger">*</span></label>
	                                    <input class="form-control" type="date" name="to">
	                                    <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Reason</label>
		                                <textarea class="form-control" name="reason"></textarea>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>File</label>
	                                    <input class="dropify" type="file" name="file" data-height="40" data-max-file-size="2M">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>