<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Edit Staff
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Edit Staff</div>
                <div class="ibox-tools">
                    <a href="#">
                    <button class="btn btn-primary btn-sm">
                        <i class="fa fa-paper-plane"></i> Import Staff
                    </button>
                </a>
                </div>
            </div>
            <div class="ibox-body" id="staff-form">
                <form action="<?= esc(route('staff.update', [$staff->id])) ?>?_method=PUT" method="POST" enctype="multipart/form-data" class="save-edit">
                    <div class="bg-grey-50 my-2 py-2 px-3 text-muted font-weight-bold">Contract Details</div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Role<span class="text-danger">*</span></label>
                                <select name="role" class="form-control custom-select">
                                    <option value="<?= esc($staff->role->id) ?>" selected><?= esc($staff->role->name) ?></option>
                                    <?php foreach ($roles as $role): ?>
                                        <option value="<?= esc($role->id) ?>"><?= esc($role->name) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Department<span class="text-danger">*</span></label>
                                <select name="department" class="form-control custom-select">
                                    <option value="<?= esc($staff->department->id) ?>" selected><?= esc($staff->department->name) ?></option>
                                    <?php foreach ($departments as $department): ?>
                                        <option value="<?= $department->id ?>"><?= $department->name ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Designation<span class="text-danger">*</span></label>
                                <select name="designation" class="form-control custom-select">
                                    <option value="<?= esc($staff->designation->id) ?>" selected><?= esc($staff->designation->title) ?></option>
                                    <?php foreach ($designations as $designation): ?>
                                        <option value="<?= $designation->id ?>"><?= $designation->title ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Staff Number<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="staff_num" value="<?= esc($staff->staff_num) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Apointment</label>
                                <select name="appointment" class="form-control custom-select">
                                    <?php if (! empty($staff->appointment)): ?>
                                        <option value="<?= esc($staff->appointment) ?>" selected><?= ucfirst(esc($staff->appointment)) ?></option>
                                    <?php else: ?>
                                        <option value="">Select</option>
                                    <?php endif ?>
                                    <option value="probation">Probation</option>
                                    <option value="permanent">Permanent</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Join Date</label>
                                <input class="form-control" type="date" name="join_date" value="<?= esc($staff->join_date) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Qualification</label>
                                <textarea class="form-control" name="qualification"><?= esc($staff->qualification) ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Experience</label>
                                <textarea class="form-control" name="experience"><?= esc($staff->experience) ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="bg-grey-50 my-2 py-2 px-3 text-muted font-weight-bold">Personal Details</div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>First Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="firstname" value="<?= esc($staff->firstname) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Other Names</label>
                                <input class="form-control" type="text" name="othername" value="<?= esc($staff->othername) ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Last Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="lastname" value="<?= esc($staff->lastname) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email</label>
                                <input class="form-control" type="email" name="email" value="<?= esc($staff->email) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone</label>
                                <input class="form-control" type="text" name="phone" value="<?= esc($staff->phone) ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Photo</label>
                                <input name="photo" type="file" class="dropify" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('image.staff', $staff->photo)) ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Birth Date</label>
                                <input name="dob"type="date" class="form-control" value="<?= esc($staff->dob) ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Gender<span class="text-danger">*</span></label>
                                <select name="gender" class="form-control custom-select">
                                    <option value="<?= esc($staff->gender) ?>" selected><?= ucfirst(esc($staff->gender)) ?></option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Religion</label>
                                <input name="religion"type="text" class="form-control" value="<?= esc($staff->religion) ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Marital Status</label>
                                <select name="status" class="form-control custom-select">
                                    <?php if (! empty($staff->status)): ?>
                                        <option value="<?= esc($staff->status) ?>" selected><?= esc($staff->status) ?></option>
                                    <?php else: ?>
                                        <option value="">Select</option>
                                    <?php endif ?>
                                    <option value="married">Married</option>
                                    <option value="single">Single</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <!-- <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="form-group">
                                <label>Country</label>
                                <select name="country" class="form-control custom-select">
                                    <option value="" selected="">Select country</option>
                                    <option value="India">India</option>
                                    <option value="Pakistan">Pakistan</option>
                                </select>
                            </div>
                        </div> -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>State</label>
                                <select name="state" class="form-control custom-select">
                                    <?php if (! empty($staff->state)): ?>
                                        <option value="<?= esc($staff->state) ?>" selected><?= esc($staff->state) ?></option>
                                    <?php else: ?>
                                        <option value="">Select</option>
                                    <?php endif ?>
                                    <option value="FCT">FCT</option>
                                    <option value="Abia">Abia</option>
                                    <option value="Adamawa">Adamawa</option>
                                    <option value="Akwa Ibom">Akwa Ibom</option>
                                    <option value="Anambara">Anambara</option>
                                    <option value="Bauchi">Bauchi</option>
                                    <option value="Bayelsa">Bayelsa</option>
                                    <option value="Benue">Benue</option>
                                    <option value="Bornu">Bornu</option>
                                    <option value="Cross River">Cross River</option>
                                    <option value="Delta">Delta</option>
                                    <option value="Ebonyi">Ebonyi</option>
                                    <option value="Edo">Edo</option>
                                    <option value="Ekiti">Ekiti</option>
                                    <option value="Enugu">Enugu</option>
                                    <option value="Gombe">Gombe</option>
                                    <option value="Imo">Imo</option>
                                    <option value="Jigawa">Jigawa</option>
                                    <option value="Kaduna">Kaduna</option>
                                    <option value="Kano">Kano</option>
                                    <option value="Katsina">Katsina</option>
                                    <option value="Kebi">Kebi</option>
                                    <option value="Kogi">Kogi</option>
                                    <option value="Kwara">Kwara</option>
                                    <option value="Lagos">Lagos</option>
                                    <option value="Nasarawa">Nasarawa</option>
                                    <option value="Niger">Niger</option>
                                    <option value="Ogun">Ogun</option>
                                    <option value="Ondo">Ondo</option>
                                    <option value="Osun">Osun</option>
                                    <option value="Oyo">Oyo</option>
                                    <option value="Plateau">Plateau</option>
                                    <option value="Rivers">Rivers</option>
                                    <option value="Sokoto">Sokoto</option>
                                    <option value="Taraba">Taraba</option>
                                    <option value="Yobe">Yobe</option>
                                    <option value="Zamfara">Zamfara</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>City</label>
                                <input name="city" type="text" class="form-control" value="<?= esc($staff->city) ?>">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Address</label>
                                <input name="address" type="text" class="form-control" value="<?= esc($staff->address) ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Emergency Contact</label>
                                <input name="alt_contact" type="text" class="form-control" value="<?= esc($staff->alt_contact) ?>">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Username<span class="text-danger">*</span></label>
                                <input name="username" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="bg-grey-50 my-2 py-2 px-3 text-muted font-weight-bold">Account Details</div>
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Account Name</label>
                                <input name="name" type="text" class="form-control" value="<?php if (! empty($staff->account->name)): ?><?= esc($staff->account->name) ?><?php endif ?>">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Account Number</label>
                                <input name="number" type="text" class="form-control" value="<?php if (! empty($staff->account->number)): ?><?= esc($staff->account->number) ?><?php endif ?>">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Bank Name</label>
                                <input name="bank" type="text" class="form-control" value="<?php if (! empty($staff->account->bank)): ?><?= esc($staff->account->bank) ?><?php endif ?>">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Branch Name</label>
                                <input name="branch" type="text" class="form-control" value="<?php if (! empty($staff->account->branch)): ?><?= esc($staff->account->branch) ?><?php endif ?>">
                            </div>
                        </div>
                    </div>
                    <!-- <div class="bg-grey-50 my-2 py-2 px-3 text-muted font-weight-bold">Social Details</div>
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Facebook</label>
                                <input name="facebook" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Twitter</label>
                                <input name="twitter" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>LinkedIn</label>
                                <input name="Linkedin" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Instagram</label>
                                <input name="instagram" type="text" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="bg-grey-50 my-2 py-2 px-3 text-muted font-weight-bold">Document Details</div>
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Application Letter</label>
                                <input name="" type="file" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>CV</label>
                                <input name="" type="file" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Certificate</label>
                                <input name="" type="file" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Afidavit</label>
                                <input name="" type="file" class="form-control">
                            </div>
                        </div>
                    </div> -->
                    <div class="form-group">
                        <button class="btn btn-primary" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>