<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Department
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Department</div>
            </div>
            <div class="ibox-body" id="department-form">
                <form action="<?= esc(route('department.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="name">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" name="remark" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="department-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Department List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="department-table" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                        	<th>#</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($departments as $department): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($department->name) ?></td>
                                <td><?= esc($department->remark) ?></td>
                                <td>
                                    <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#sect-edit-<?= esc($department->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button>
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#sect-del-<?= esc($department->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="sect-del-<?= esc($department->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Department</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('department.delete', [$department->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($department) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="sect-edit-<?= esc($department->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Department</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('department.update', [$department->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Name<span class="text-danger">*</span></label>
								                                <input class="form-control" type="text" name="name" value="<?= esc($department->name) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Description</label>
								                                <textarea class="form-control" name="remark" rows="3"><?= esc($department->remark) ?></textarea>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>