<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Staff Attendance
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-search"></i> Search Criteria</div>
            </div>
            <div class="ibox-body" id="staff-attendance-filter">
                <form action="<?= esc(route('staff_attendance.index')) ?>" method="GET">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Role<span class="text-danger">*</span></label>
                                <select name="role" class="form-control custom-select">
                                    <?php if (! empty($currentrole)): ?>
                                        <option value="<?= esc($currentrole->id) ?>"><?= esc($currentrole->name) ?></option>
                                    <?php endif ?>
                                    <option value="">Select</option>
                                    <?php foreach ($roles as $role): ?>
                                        <option value="<?= esc($role->id) ?>"><?= esc($role->name) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Date<span class="text-danger">*</span></label>
                                <input type="date" name="date" class="form-control attend-date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group pb-4">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary rounded form-control px-5" type="submit" id="staff-attend-btn">
                                    <i class="fa fa-filter"></i>&nbsp;Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if (! empty($staffs)): ?>
<div class="row">
    <div class="col-md-12">
        <form action="<?= esc(route('staff_attendance.save')) ?>" method="POST" id="staff-attend-form" class="attend-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-pencil"></i> Staff Attendance Entry</div>
                    <div class="ibox-tools">
                        <label class="ui-radio ui-radio-default mr-3">
                            <input type="radio" id="deselect-all" name="for_all">
                            <span class="input-span"></span>
                        </label>
                        <label class="ui-radio ui-radio-success mr-3">
                            <input type="radio" id="present-all" name="for_all">
                            <span class="input-span"></span>
                        </label>
                        <label class="ui-radio ui-radio-info mr-3">
                            <input type="radio" id="holiday-all" name="for_all">
                            <span class="input-span"></span>
                        </label>
                        <label class="ui-radio ui-radio-warning mr-3">
                            <input type="radio" id="late-all" name="for_all">
                            <span class="input-span"></span>
                        </label>
                        <label class="ui-radio ui-radio-danger mr-3">
                            <input type="radio" id="absent-all" name="for_all">
                            <span class="input-span"></span>
                        </label>
                        <button class="btn btn-primary" type="submit" id="save-staff-attend">
                            <i class="fa fa-save"></i>&nbsp;Save Attendance
                        </button>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentrole) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($attend_date) ?></span>
                        </div>
                    </div>
                    <table class="table table-bordered table-hover data-table" id="table" cellspacing="0" width="100%" >
                        <thead class="thead-light">
                            <tr>
                                <th>Name</th>
                                <th>Staff ID</th>
                                <th>Status</th>
                                <th>Remark</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (! empty($attendances)): ?>
                            <?php foreach ($attendances as $attendance): ?>
                            <tr class="table-row">
                                <td><?= esc($attendance->staff) ?></td>
                                <td><?= esc($attendance->staff->staff_num) ?></td>
                                <input type="hidden" class="staff" value="<?= esc($attendance->staff->id) ?>" name="staff<?= esc(counter()) ?>">
                                <input type="hidden" class="date" value="<?= esc($attendance->date) ?>" name="date<?= esc(counter()) ?>">
                                <td>
                                    <label class="ui-radio ui-radio-success mr-4">
                                        <input type="radio" name="status<?= esc($attendance->staff->id) ?>" value="present" class="status present" <?= $attendance->status === 'present' ? 'checked' : '' ?>>
                                        <span class="input-span"></span>Present
                                    </label>
                                    <label class="ui-radio ui-radio-info mr-4">
                                        <input type="radio" name="status<?= esc($attendance->staff->id) ?>" value="holiday" class="status holiday" <?= $attendance->status === 'holiday' ? 'checked' : '' ?>>
                                        <span class="input-span"></span>Holiday
                                    </label>
                                    <label class="ui-radio ui-radio-warning mr-4">
                                        <input type="radio" name="status<?= esc($attendance->staff->id) ?>" value="late" class="status late" <?= $attendance->status === 'late' ? 'checked' : '' ?>>
                                        <span class="input-span"></span>Late
                                    </label>
                                    <label class="ui-radio ui-radio-danger">
                                        <input type="radio" name="status<?= esc($attendance->staff->id) ?>" value="absent" class="status absent" <?= $attendance->status === 'absent' ? 'checked' : '' ?>>
                                        <span class="input-span"></span>Absent
                                    </label>
                                </td>
                                <td><input type="text" name="remark<?= esc(counter()) ?>" class="form-control remark" value="<?= esc($attendance->remark) ?>"></td>
                            </tr>
                            <?php endforeach ?>
                        <?php else: ?>
                            <?php foreach ($staffs as $staff): ?>
                            <tr class="table-row">
                                <td><?= esc($staff) ?></td>
                                <td><?= esc($staff->staff_num) ?></td>
                                <input type="hidden" class="staff" value="<?= esc($staff->id) ?>" name="staff<?= esc(counter()) ?>">
                                <input type="hidden" class="date" value="<?= esc($attend_date) ?>" name="date<?= esc(counter()) ?>">
                                <td>
                                    <label class="ui-radio ui-radio-success mr-4">
                                        <input type="radio" name="status<?= esc($staff->id) ?>" value="present" class="status present">
                                        <span class="input-span"></span>Present
                                    </label>
                                    <label class="ui-radio ui-radio-info mr-4">
                                        <input type="radio" name="status<?= esc($staff->id) ?>" value="holiday" class="status holiday">
                                        <span class="input-span"></span>Holiday
                                    </label>
                                    <label class="ui-radio ui-radio-warning mr-4">
                                        <input type="radio" name="status<?= esc($staff->id) ?>" value="late" class="status late">
                                        <span class="input-span"></span>Late
                                    </label>
                                    <label class="ui-radio ui-radio-danger">
                                        <input type="radio" name="status<?= esc($staff->id) ?>" value="absent" class="status absent">
                                        <span class="input-span"></span>Absent
                                    </label>
                                </td>
                                <td><input type="text" name="remark<?= esc(counter()) ?>" class="form-control remark"></td>
                            </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif ?>
<?php endsection() ?>