<?php extend_layout('admin/layouts/base') ?>
<?php section('status') ?>
active
<?php endsection() ?>
<?php section('title') ?>
Staff List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Staff List</div>
                <div class="ibox-tools">
                    <a href="<?= esc(route('staff.add')) ?>">
                        <button class="btn btn-primary btn-sm">
                            <i class="fa fa-plus"></i> Add Staff
                        </button>
                    </a>
                </div>
            </div>
            <div class="ibox-body">
                <table class="table table-striped table-bordered table-hover table-responsive-sm data-table" id="" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>Photo</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Age</th>
                            <th>Gender</th>
                            <th>Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($all_staff as $staff): ?>
                            <tr>
                                <td><?= esc(counter()) ?></td>
                                <td>
                                    <img src="<?= esc(source('image.staff', $staff->photo)) ?>" alt="staff-photo" width="40">
                                </td>
                                <td><?= esc($staff->firstname) ?> <?= esc($staff->lastname) ?></td>
                                <td><?= esc($staff->email) ?></td>
                                <td><?= esc($staff->phone) ?></td>
                                <td><?= esc($staff->dob) ?></td>
                                <td><?= esc(ucfirst($staff->gender)) ?></td>
                                <td><?= esc($staff->address) ?></td>
                                <td>
                                    <div class="ibox-tools">
                                        <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                                        <div class="dropdown-menu dropdown-menu">
                                            <a href="<?= esc(route('staff_profile.detail', ['id' => $staff->id])) ?>" class="dropdown-item"><i class="fa fa-eye"></i> View</a>
                                            <a href="<?= esc(route('staff.edit', ['id' => $staff->id])) ?>" class="dropdown-item"><i class="fa fa-edit"></i> Edit</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>