<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Store inventory settings
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-info-circle"></i> Add all the products to store</div>
            </div>
            <div class="ibox-body" id="store-inventory-form">
                <div>
                    <h3>Add all the products to store</h3>
                </div>
                <!-- <form action="" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-control-label">Store<span class="text-danger">*</span></label>
                                <select name="store_inventory" class="form-control custom-select">
                                    <option value="">Select</option>
                                    <?php// foreach ($stores as $store): ?>
                                    <option value="<?//= esc($store->id) ?>"><?//= esc($store) ?></option>
                                    <?php// endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form> -->
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="store-inventory-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Store List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="store-inventory-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>Stores</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stores as $store): ?>
                            <tr>
                                <td><?= esc(counter()) ?></td>
                                <td><?= esc($store->name) ?></td>
                                <td>
                                    <?php if ($store->inventorys->count() > 0): ?>
                                        <i class="fa fa-check text-success">
                                    <?php else: ?>
                                        <i class="fa fa-warning text-warning">
                                    <?php endif ?>
                                </td>
                                <td>
                                    <?php if ($store->inventorys->count() > 0): ?>
                                        <button type="button" class="btn btn-default btn-xs" title="Add" disabled>
                                            <i class="fa fa-plus font-14"></i>
                                        </button>
                                    <?php else: ?>
                                        <a href="<?= esc(route('store_inventory.create', ['id' => $store->id])) ?>" class="btn btn-default btn-xs add-product-store" title="Add">
                                            <i class="fa fa-plus font-14"></i>
                                        </a>
                                    <?php endif ?>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>