<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Role
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Role</div>
            </div>
            <div class="ibox-body" id="role-form">
                <form action="<?= esc(route('role.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Name<span class="text-danger">*</span></label>
                                <input class="form-control ui-input-gray" type="text" name="name">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group kb">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="role-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Role List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="role-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($roles as $role): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($role->name) ?></td>
                                <td><?= esc($role->slug) ?></td>
                                <td>
                                    <a href="<?= esc(route('role_permission.index', [$role->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Assign permission"><i class="fa fa-tag font-14"></i></a>
                                    <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#sect-edit-<?= esc($role->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button>
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#sect-del-<?= esc($role->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="sect-del-<?= esc($role->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Role</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('role.delete', [$role->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($role) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="sect-edit-<?= esc($role->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Role</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('role.update', [$role->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12 kn">
								                            <div class="form-group">
								                                <label>Name<span class="text-danger">*</span></label>
								                                <input class="form-control" type="text" name="name" value="<?= esc($role->name) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group kb">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>