<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Role Permission
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <form action="<?= esc(route('role_permission.create')) ?>" method="POST" id="role-perm-form" class="perm-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-pencil"></i> Permissions For <b><em>(<?= esc($role) ?>)</em></b></div>
                    <div class="ibox-tools">
                        <button class="btn btn-primary" type="submit" id="save-role-perm">
                            <i class="fa fa-save"></i>&nbsp;Save Permission
                        </button>
                    </div>
                </div>
                <div class="ibox-body">
                    <table class="table table-sm table-bordered table-hover" id="table" cellspacing="0" width="100%" >
                        <thead>
                            <tr>
                                <th>Module</th>
                                <th>Permission</th>
                                <th>Create</th>
                                <th>Read</th>
                                <th>Update</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php $th_counts = []; ?>
                            <?php foreach ($permissions as $permission): ?>
                            	<?php $role_perm = $permission->role_permissions->filter(['role' => $role])->one() ?>
                            <tr class="table-row">
                                <th><?= esc(!in_array($permission->module->id, $th_counts) ? $permission->module : '') ?></th>
                            	<?php 
                            		if (!in_array($permission->module->id, $th_counts)) {
                            			array_push($th_counts, $permission->module->id); 
                            		}
                            	?>
                                <td><?= esc($permission) ?></td>
                                <input type="hidden" class="permission" value="<?= esc($permission->id) ?>" name="permission<?= esc(counter()) ?>">
                                <input type="hidden" class="role" value="<?= esc($role->id) ?>" name="role<?= esc(counter()) ?>">
                                <td>
                                	<?php if ($permission->enable_create): ?>
                                		<label class="ui-checkbox ui-checkbox-primary">
	                                        <input type="checkbox" name="can_create_<?= esc($permission->id) ?>" value="1" class="can-create" <?= $role_perm !== null && $role_perm->can_create === '1' ? 'checked' : '' ?>>
	                                        <span class="input-span"></span>
	                                    </label>
                                	<?php endif ?>
                                </td>
                                <td>
                                	<?php if ($permission->enable_read): ?>
                                		<label class="ui-checkbox ui-checkbox-primary">
	                                        <input type="checkbox" name="can_read_<?= esc($permission->id) ?>" value="1" class="can-read" <?= $role_perm !== null && $role_perm->can_read === '1' ? 'checked' : '' ?>>
	                                        <span class="input-span"></span>
	                                    </label>
                                	<?php endif ?>
                                </td>
                                <td>
                                	<?php if ($permission->enable_update): ?>
                                		<label class="ui-checkbox ui-checkbox-primary">
	                                        <input type="checkbox" name="can_update_<?= esc($permission->id) ?>" value="1" class="can-update" <?= $role_perm !== null && $role_perm->can_update === '1' ? 'checked' : '' ?>>
	                                        <span class="input-span"></span>
	                                    </label>
                                	<?php endif ?>
                                </td>
                                <td>
                                	<?php if ($permission->enable_delete): ?>
                                		<label class="ui-checkbox ui-checkbox-primary">
	                                        <input type="checkbox" name="can_delete_<?= esc($permission->id) ?>" value="1" class="can-delete" <?= $role_perm !== null && $role_perm->can_delete === '1' ? 'checked' : '' ?>>
	                                        <span class="input-span"></span>
	                                    </label>
                                	<?php endif ?>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endsection() ?>