<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
General settings
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> General Settings</div>
                <div class="ibox-tools">
                </div>
            </div>
            <div class="ibox-body" id="company-form">
                <form action="<?= esc(route('company.update')) ?>?_method=PUT" method="POST" enctype="multipart/form-data" class="save-edit">
                	<?php // echo csrf() ?>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="name" value="<?= esc($company->name ?? '') ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone Number<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="phone" value="<?= esc($company->phone ?? '') ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email Address<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="email" value="<?= esc($company->email ?? '') ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Logo<span class="text-danger">*</span></label>
                                <?php if ($company): ?>
                                	<input name="logo" type="file" class="dropify" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('image.company', $company->logo)) ?>">
                                <?php else: ?>
                                	<input name="logo" type="file" class="dropify" data-height="20">
                                <?php endif ?>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone Number 2<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="phone2" value="<?= esc($company->phone2 ?? '') ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email Address 2</label>
                                <input class="form-control" type="text" name="email2" value="<?= esc($company->email2 ?? '') ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Address</label>
                                <textarea class="form-control" name="address"><?= esc($company->address ?? '') ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Note</label>
                                <textarea class="form-control" name="note"><?= esc($company->note ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>