<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Low Inventory Notification
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="inventory-ibox">
            <div class="ibox-head">
            	<div class="ibox-title"><i class="fa fa-list"></i> Low Inventory Notifications</div>
                <div class="ibox-tools"> </div>
            </div>
            <div class="ibox-body dt-show" id="inventory-form">
            	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="inventory-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Product</th>
                            <th>Store</th>
                            <th>Quantity</th>
                            <th>Min Qty</th>
                            <th>Status</th>
                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($inventorys as $inventory): ?>
                            <?php if ($inventory->quantity <= $inventory->low): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($inventory->product) ?></td>
                                <td><?= esc($inventory->store) ?></td>
                                <td><?= esc($inventory->quantity) ?></td>
                                <td><?= esc($inventory->low) ?></td>
                                <td><?= esc($inventory->status) ?></td>
                                <!-- <td>
                                    <a href="<?//= esc(route('inventory.detail', [$inventory->id, $inventory->bill_code])) ?>" class="btn btn-default btn-xs m-r-5" title="View"><i class="fa fa-eye font-14"></i></a>
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#inventory-del-<?//= esc($inventory->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td> -->
                               	<div class="modal fade" id="inventory-del-<?= esc($inventory->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete inventory</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?//= esc(route('inventory.delete', [$inventory->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($inventory->bill_code) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                            <?php endif ?>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>