<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Sales Income
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="invoice-ibox">
            <div class="ibox-head">
            	<div class="ibox-title"><i class="fa fa-list"></i> Income List</div>
                <div class="ibox-tools"> </div>
            </div>
            <div class="ibox-body dt-show" id="invoice-form">
            	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="invoice-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Date</th>
                            <th>Store</th>
                            <th>Sales</th>
                            <th>Cedit</th>
                            <th>total</th>
                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoices as $invoice): ?>
                            <tr>
                                <?php 
                                    $first_sale;
                                    $sales = $invoice->sales->all();
                                    $total_price = $invoice->sales->sum('total_price');
                                    $amount = $invoice->payments->sum('amount');
                                ?>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($invoice->date) ?></td>
                                <td><?php
                                    foreach ($sales as $sale) {
                                        echo $sale->inventory->store;
                                        break;
                                    } ?>
                                    <!-- <?//= esc($first_sale->inventory->store) ?> -->
                                </td>
                                <td><?= esc($total_price) ?></td>
                                <td><?= esc($amount) ?></td>
                                <td><?= esc((int)$total_price + (int)$amount) ?></td>
                                <!-- <td>
                                    <a href="<?= esc(route('invoice.detail', [$invoice->id, $invoice->bill_code])) ?>" class="btn btn-default btn-xs m-r-5" title="View"><i class="fa fa-eye font-14"></i></a>
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#invoice-del-<?= esc($invoice->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td> -->
                               	<div class="modal fade" id="invoice-del-<?= esc($invoice->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete invoice</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('invoice.delete', [$invoice->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($invoice->bill_code) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>