<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Stock
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="stock-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-8-1" data-toggle="tab"><i class="fa fa-list"></i> Stock List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-8-2" data-toggle="tab"><i class="fa fa-edit"></i> Add Stock</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="stock-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab-8-1">
                    	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="stock-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Product</th>
		                            <th>Store</th>
		                            <th>Quantity</th>
		                            <th>Stock Price</th>
		                            <th>Batch Code</th>
		                            <th>Stock Date</th>
		                            <th>Remark</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($stocks as $stock): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($stock->inventory->product) ?></td>
		                                <td><?= esc($stock->inventory->store) ?></td>
		                                <td><?= esc($stock->quantity) ?></td>
		                                <td><?= esc($stock->price) ?></td>
		                                <td><?= esc($stock->batch_code) ?></td>
		                                <td><?= esc($stock->date) ?></td>
		                                <td><?= esc($stock->remark) ?></td>
		                                <td>
		                                    <a href="<?= esc(route('stock.edit', [$stock->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($stock->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($stock->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Stock</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('stock.delete', [$stock->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($stock) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="tab-8-2">
                    	<form action="<?= esc(route('stock.create')) ?>" method="POST" id="stock-form">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Store<span class="text-danger">*</span></label>
			                        	<select name="store" class="form-control custom-select" id="store">
			                                <option value="">Select</option>
			                                <?php foreach ($stores as $store): ?>
			                                    <option value="<?= esc($store->id) ?>"><?= esc($store->name) ?></option>
			                                <?php endforeach ?>
			                            </select>
			                            <div class="invalid-feedback"></div>
			                        </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Batch Code<span class="text-danger">*</span></label>
		                                <input name="" type="text" class="form-control" id="batch-code">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Date<span class="text-danger">*</span></label>
		                                <input class="form-control" type="date" name="date" id="date">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row my-4">
		                    	<div class="col-md-12">
		                    		<table class="table table-sm table-bordered table-hover table-responsive-sm" id="stock-table" cellspacing="0" width="100%">
					                    <thead class="thead-light">
					                        <tr>
					                            <th>Product</th>
					                            <th>Purchase</th>
					                            <th>Quantity</th>
					                            <th>Price</th>
					                            <th>Remark</th>
					                            <th>
					                            	<a href="javascript:void(0)" class="btn btn-primary btn-xs" id="add-stock-row">
								                		<i class="fa fa-plus font-14"></i>
								                	</a>
					                            </th>
					                        </tr>
					                    </thead>
					                    <tbody class="stock-tbody">
				                            <tr class="table-row" id="stock-row-0">
				                                <td>
				                                	<select name="product_0" class="form-control custom-select product">
					                                    <option value="" selected="">Select</option>
					                                    <?php foreach ($products as $product): ?>
					                                        <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
					                                    <?php endforeach ?>
					                                </select>
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<select name="purchase_0" class="form-control custom-select purchase">
					                                    <option value="" selected="">Select</option>
					                                    <?php foreach ($purchases as $purchase): ?>
					                                        <option value="<?= esc($purchase->id) ?>"><?= esc($purchase->batch_code) ?></option>
					                                    <?php endforeach ?>
					                                </select>
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<input class="form-control quantity" type="number" name="quantity_0">
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<input class="form-control price" type="number" name="price_0">
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td><input class="form-control remark" type="text" name="remark_0"></td>
				                                <td>
				                                	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="stock-row-0">
								                		<i class="fa fa-times font-14"></i>
								                	</a>
				                                </td>
				                            </tr>
					                    </tbody>
					                </table>
		                    	</div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>
<?php section("scripts") ?>
    <script type="text/javascript">
        $(document).ready(function() {
            var counter = 0;
            $('body #stock-ibox').on('click', '#add-stock-row', function() {
                counter += 1;
                $('.stock-tbody').append(`
                    <tr class="table-row" id="stock-row-${counter}">
                        <td>
                        	<select name="product_${counter}" class="form-control custom-select product">
                                <option value="" selected="">Select</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<select name="purchase_${counter}" class="form-control custom-select purchase">
                                <option value="" selected="">Select</option>
                                <?php foreach ($purchases as $purchase): ?>
                                    <option value="<?= esc($purchase->id) ?>"><?= esc($purchase->batch_code) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<input class="form-control quantity" type="number" name="quantity_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<input class="form-control price" type="number" name="price_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td><input class="form-control remark" type="text" name="remark_${counter}"></td>
                        <td>
                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="stock-row-${counter}">
		                		<i class="fa fa-times font-14"></i>
		                	</a>
                        </td>
                    </tr>
                `);
            });
            
            $('form .stock-tbody').on('click', '.remove-row-btn', function() {
                var remove_id = $(this).data('remove-btn');
                $('#' + remove_id).remove();
            });
        });
    </script>
<?php endsection() ?>