<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product stock edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="stock-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('stock.index')) ?>"><i class="fa fa-list"></i> Stock List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Stock</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="stock-form">
                <div class="tab-content">
                    <div class="tab-pane show active" id="edit">
                    	<form action="<?= esc(route('stock.update', [$stock->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Stock Date</label>
		                                <input class="form-control" type="date" name="date" value="<?= esc($stock->date) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Batch Code<span class="text-danger">*</span></label>
		                                <input name="batch_code" type="text" class="form-control" value="<?= esc($stock->batch_code) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div><div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Product<span class="text-danger">*</span></label>
		                                <select name="product" class="form-control custom-select">
		                                	<option value="<?= esc($stock->product->id) ?>" selected><?= esc($stock->product) ?></option>
		                                	<?php foreach ($products as $product): ?>
		                                		<option value="<?= esc($product->id) ?>"><?= esc($product) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Store</label>
		                                <select name="store" class="form-control custom-select">
		                                	<option value="<?= esc($stock->store->id ?? "") ?>" selected><?= esc($stock->store ?? "Select") ?></option>
		                                	<?php foreach ($stores as $store): ?>
		                                		<option value="<?= esc($store->id) ?>"><?= esc($store) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="number" name="quantity" value="<?= esc($stock->quantity) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <input class="form-control" type="text" name="remark" value="<?= esc($stock->remark) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>