<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product sale edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="sale-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('sale.index')) ?>"><i class="fa fa-list"></i> Sale List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Sale</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="sale-form">
                <div class="tab-content">
                    <div class="tab-pane show active" id="edit">
                    	<form action="<?= esc(route('sale.update', [$sale->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Sale Date</label>
		                                <input class="form-control" type="date" name="date" value="<?= esc($sale->date) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Batch Code<span class="text-danger">*</span></label>
		                                <input name="batch_code" type="text" class="form-control" value="<?= esc($sale->batch_code) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div><div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Product<span class="text-danger">*</span></label>
		                                <select name="product" class="form-control custom-select">
		                                	<option value="<?= esc($sale->product->id) ?>" selected><?= esc($sale->product) ?></option>
		                                	<?php foreach ($products as $product): ?>
		                                		<option value="<?= esc($product->id) ?>"><?= esc($product) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Store</label>
		                                <select name="store" class="form-control custom-select">
		                                	<option value="<?= esc($sale->store->id ?? "") ?>" selected><?= esc($sale->store ?? "Select") ?></option>
		                                	<?php foreach ($stores as $store): ?>
		                                		<option value="<?= esc($store->id) ?>"><?= esc($store) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="number" name="quantity" value="<?= esc($sale->quantity) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <input class="form-control" type="text" name="remark" value="<?= esc($sale->remark) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>