<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Sale
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="sale-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Sales List</div>
                <div class="ibox-tools">
                    <!-- <a href="<?//= esc(route('invoice.add')) ?>">
                        <button class="btn btn-primary btn-sm">
                            <i class="fa fa-plus"></i> Add Invoice
                        </button>
                    </a> -->
                </div>
            </div>
            <div class="ibox-body dt-show" id="sale-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab-8-1">
                    	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="sale-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Product</th>
		                            <th>Store</th>
		                            <th>Quantity</th>
		                            <th>Sale Price</th>
		                            <th>Total Price</th>
		                            <th>Batch Code</th>
		                            <th>Sale Date</th>
		                            <th>Remark</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($sales as $sale): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($sale->inventory->product) ?></td>
		                                <td><?= esc($sale->inventory->store) ?></td>
		                                <td><?= esc($sale->quantity) ?></td>
		                                <td><?= esc($sale->unit_price) ?></td>
		                                <td><?= esc($sale->total_price) ?></td>
		                                <td><?= esc($sale->invoice->bill_code) ?></td>
		                                <td><?= esc($sale->invoice->date) ?></td>
		                                <td><?= esc($sale->remark) ?></td>
		                                <td>
		                                    <a href="<?= esc(route('sale.edit', [$sale->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($sale->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($sale->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Sale</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('sale.delete', [$sale->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($sale) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>