<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Sale
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="sale-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-plus"></i> Add Sale</div>
                <div class="ibox-tools">
                	<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#add-customer">
                		<i class="fa fa-plus"></i>&nbsp; Add Customer
                	</button>
                    <a href="<?= esc(route('sale.index')) ?>">
                        <button class="btn btn-primary btn-sm">
                            <i class="fa fa-bars"></i>&nbsp; All Sale
                        </button>
                    </a>
                </div>
            </div>
            <div class="ibox-body" id="sale-data">
            	<!-- <input type="hidden" name="product_data" value="<?//= esc(route('product.data').'?p_id=') ?>"> -->
            	<form action="<?= esc(route('sale.create')) ?>" method="POST" id="sale-form">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Invoice Number<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="bill_code" id="bill-code" value="<?= mt_rand(100000, 999999) ?>" readonly>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Store<span class="text-danger">*</span></label>
                            	<select name="store" class="form-control custom-select" id="store">
                                    <option value="">Select</option>
                                    <?php foreach ($stores as $store): ?>
                                        <option value="<?= esc($store->id) ?>"><?= esc($store->name) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Customer<span class="text-danger">*</span></label>
                            	<select name="customer" class="form-control custom-select" id="customer">
                                    <option value="">Select</option>
                                    <?php foreach ($customers as $customer): ?>
                                        <option value="<?= esc($customer->id) ?>"><?= esc($customer->name) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date<span class="text-danger">*</span></label>
                                <input class="form-control date" type="date" name="date" id="date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-4">
                    	<div class="col-md-12">
                    		<table class="table table-sm table-bordered table-hover table-responsive-sm" id="sale-table" cellspacing="0" width="100%">
			                    <thead class="thead-light">
			                        <tr>
			                            <th>Product</th>
			                            <th>Stock Quantity</th>
			                            <th>Quantity</th>
			                            <th>Unit Price</th>
			                            <th>Total Price</th>
			                            <th>Remark</th>
			                            <th>
			                            	<a href="javascript:void(0)" class="btn btn-primary btn-xs" id="add-sale-row">
						                		<i class="fa fa-plus font-14"></i>
						                	</a>
			                            </th>
			                        </tr>
			                    </thead>
			                    <tbody class="sale-tbody">
		                            <tr class="table-row" id="sale-row-0">
		                                <td>
		                                	<select name="product_0" class="form-control select2_demo_2 product" data-url="<?= esc(route('product.data').'?p_id=') ?>">
			                                    <option value="">Select</option>
			                                    <?php foreach ($products as $product): ?>
			                                        <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
			                                    <?php endforeach ?>
			                                </select>
			                                <div class="invalid-feedback"></div>
		                                </td>
		                                <td><input class="form-control stock_qty" type="text" name="stock_qty_0" readonly></td>
		                                <td>
		                                	<input class="form-control quantity" type="number" name="quantity_0">
			                                <div class="invalid-feedback"></div>
		                                </td>
		                                <td><input class="form-control unit_price" type="text" name="unit_price_0" readonly></td>
		                                <td><input class="form-control total_price" type="text" name="total_price_0" readonly></td>
		                                <td><input class="form-control remark" type="text" name="remark_0"></td>
		                                <td>
		                                	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="sale-row-0">
						                		<i class="fa fa-times font-14"></i>
						                	</a>
		                                </td>
		                            </tr>
			                    </tbody>
			                </table>
                    	</div>
                    </div>
	                <div class="row mb-4 justify-content-end">
	                	<div class="col-md-4">
	                		<div class="card">
					            <div class="card-header">
					                <h4 class="card-title">Summary</h4>
					            </div>
					            <div class="card-body">
					            	<table class="table table-bordered table-sm table-responsive-sm">
	                                    <tbody>
	                                        <tr>
	                                            <td>Total Anount</td>
	                                            <td>
	                                            	<input class="form-control" id="total-amount" type="text" name="total_amount" value="0" readonly>
	                                            </td>
	                                        </tr>
	                                        <tr>
	                                            <td>Discount</td>
	                                            <td>
	                                            	<input class="form-control" id="discount" type="text" name="discount" value="0">
	                                            </td>
	                                        </tr>
	                                        <tr>
	                                            <td>Grand Total</td>
	                                            <td>
	                                            	<input class="form-control" id="amount" type="text" name="amount" value="0" readonly>
	                                            </td>
	                                        </tr>
	                                        <tr>
	                                            <td>Paid</td>
	                                            <td>
	                                            	<input class="form-control" id="paid" type="text" name="paid" value="0">
	                                            </td>
	                                        </tr>
	                                        <tr>
	                                            <td>Balance</td>
	                                            <td>
	                                            	<input class="form-control" id="balance" type="text" name="balance" value="0" readonly>
	                                            </td>
	                                        </tr>
	                                        <tr>
	                                            <td>Payment Mode</td>
	                                            <td>
	                                            	<select name="payment_mode" class="form-control custom-select payment_mode" id="payment-mode">
					                                    <?php foreach ($payment_modes as $payment_mode): ?>
					                                        <option value="<?= esc($payment_mode->id) ?>"<?php if (strtolower($payment_mode->via) == 'cash'): ?> selected<?php endif ?>>
					                                        	<?= esc($payment_mode->via) ?>
					                                        </option>
					                                    <?php endforeach ?>
					                                </select>
	                                            </td>
	                                        </tr>
	                                    </tbody>
	                                </table>
					            </div>
					        </div>
					    </div>
	                </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
            <div class="modal fade" id="add-customer" data-backdrop="static" tabindex="-1" aria-hidden="true">
			  	<div class="modal-dialog">
				    <div class="modal-content rounded">
				      	<div class="modal-header">
					        <h4 class="modal-title"><i class="fa fa-plus"></i> Add Customer</h4>
					        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
				      	</div>
				      	<div class="modal-body">
					        <form action="<?= esc(route('customer.create')) ?>" method="POST" id="add-customer-form">
			                    <div class="row">
			                        <div class="col-md-12">
			                            <div class="form-group">
			                                <label>Name<span class="text-danger">*</span></label>
			                                <input class="form-control" type="text" name="name">
			                                <div class="invalid-feedback"></div>
			                            </div>
			                        </div>
			                        <div class="col-md-12">
			                            <div class="form-group">
			                                <label>Email</label>
			                                <input class="form-control" type="email" name="email">
			                                <div class="invalid-feedback"></div>
			                            </div>
			                        </div>
			                        <div class="col-md-12">
			                            <div class="form-group">
			                                <label>Phone</label>
			                                <input class="form-control" type="text" name="phone">
			                                <div class="invalid-feedback"></div>
			                            </div>
			                        </div>
			                        <div class="col-md-12">
			                            <div class="form-group">
			                                <label>Address</label>
			                                <textarea class="form-control" name="address"></textarea>
			                            </div>
			                        </div>
			                        <div class="col-md-12">
			                            <div class="form-group">
			                                <label>Remark</label>
			                                <textarea class="form-control" name="remark"></textarea>
			                            </div>
			                        </div>
			                    </div>
			                    <div class="form-group">
			                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
			                        <button class="btn btn-primary rounded" type="submit">Update</button>
			                    </div>
			                </form>
				      	</div>
				    </div>
			  	</div>
			</div>
        </div>
	</div>
</div>
<?php endsection() ?>
<?php section("scripts") ?>
    <script type="text/javascript">
        $(document).ready(function() {
            var counter = 0;
            $('body #sale-ibox').on('click', '#add-sale-row', function() {
                counter += 1;
                $('.sale-tbody').append(`
                    <tr class="table-row" id="sale-row-${counter}">
                        <td>
                        	<select name="product_${counter}" class="form-control custom-select product" data-url="<?= esc(route('product.data').'?p_id=') ?>">
                                <option value="">Select</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </td>
                        <td><input class="form-control stock_qty" type="text" name="stock_qty_${counter}" readonly></td>
                        <td>
                        	<input class="form-control quantity" type="number" name="quantity_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td><input class="form-control unit_price" type="text" name="unit_price_${counter}" readonly></td>
                        <td><input class="form-control total_price" type="text" name="total_price_${counter}" readonly></td>
                        <td><input class="form-control remark" type="text" name="remark_${counter}"></td>
                        <td>
                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="sale-row-${counter}">
		                		<i class="fa fa-times font-14"></i>
		                	</a>
                        </td>
                    </tr>
                `);
            });
            
            $('form .sale-tbody').on('click', '.remove-row-btn', function() {
                var remove_id = $(this).data('remove-btn');
                $('#' + remove_id).remove();
            });
        });
    </script>
<?php endsection() ?>