<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Purchase
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="purchase-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-8-1" data-toggle="tab"><i class="fa fa-list"></i> Purchase List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-8-2" data-toggle="tab"><i class="fa fa-edit"></i> Add Purchase</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="purchase-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab-8-1">
                    	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="purchase-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Product</th>
		                            <th>Supplier</th>
		                            <th>Quantity</th>
		                            <th>Purchase Price</th>
		                            <th>Selling Price</th>
		                            <th>Batch Code</th>
		                            <th>Purchase Date</th>
		                            <th>Price Update</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($purchases as $purchase): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($purchase->product) ?></td>
		                                <td><?= esc($purchase->supplier) ?></td>
		                                <td><?= esc($purchase->quantity) ?></td>
		                                <td><?= esc($purchase->purchase_price) ?></td>
		                                <td><?= esc($purchase->selling_price) ?></td>
		                                <td><?= esc($purchase->batch_code) ?></td>
		                                <td><?= esc($purchase->date) ?></td>
		                                <td><?= esc($purchase->price_update) ?></td>
		                                <td>
		                                    <a href="<?= esc(route('purchase.edit', [$purchase->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($purchase->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($purchase->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Purchase</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('purchase.delete', [$purchase->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($purchase) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="tab-8-2">
                    	<form action="<?= esc(route('purchase.create')) ?>" method="POST" id="purchase-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Date<span class="text-danger">*</span></label>
		                                <input class="form-control" type="date" name="" id="date">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Batch Code<span class="text-danger">*</span></label>
		                                <input name="" type="text" class="form-control" id="batch-code">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row my-4">
		                    	<div class="col-md-12">
		                    		<table class="table table-sm table-bordered table-hover table-responsive-sm" id="purchase-table" cellspacing="0" width="100%">
					                    <thead class="thead-light">
					                        <tr>
					                            <th>Product</th>
					                            <th>Supplier</th>
					                            <th>Quantity</th>
					                            <th>Purchase Price</th>
					                            <th>Selling Price</th>
					                            <th>Remark</th>
					                            <th>
					                            	<a href="javascript:void(0)" class="btn btn-primary btn-xs" id="add-purchase-row">
								                		<i class="fa fa-plus font-14"></i>
								                	</a>
					                            </th>
					                        </tr>
					                    </thead>
					                    <tbody class="purchase-tbody">
				                            <tr class="table-row" id="purchase-row-0">
				                                <td>
				                                	<select name="product_0" class="form-control custom-select product">
					                                    <option value="" selected="">Select</option>
					                                    <?php foreach ($products as $product): ?>
					                                        <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
					                                    <?php endforeach ?>
					                                </select>
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<select name="supplier_0" class="form-control custom-select supplier">
					                                    <option value="" selected="">Select</option>
					                                    <?php foreach ($suppliers as $supplier): ?>
					                                        <option value="<?= esc($supplier->id) ?>"><?= esc($supplier->name) ?></option>
					                                    <?php endforeach ?>
					                                </select>
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<input class="form-control quantity" type="number" name="quantity_0">
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<input class="form-control purchase_price" type="text" name="purchase_price_0">
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td>
				                                	<input class="form-control selling_price" type="text" name="selling_price_0">
					                                <div class="invalid-feedback"></div>
				                                </td>
				                                <td><input class="form-control remark" type="text" name="remark_0"></td>
				                                <td>
				                                	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="purchase-row-0">
								                		<i class="fa fa-times font-14"></i>
								                	</a>
				                                </td>
				                            </tr>
					                    </tbody>
					                </table>
		                    	</div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>
<?php section("scripts") ?>
    <script type="text/javascript">
        $(document).ready(function() {
            var counter = 0;
            $('body #purchase-ibox').on('click', '#add-purchase-row', function() {
                counter += 1;
                $('.purchase-tbody').append(`
                    <tr class="table-row" id="purchase-row-${counter}">
                        <td>
                        	<select name="product_${counter}" class="form-control custom-select product">
                                <option value="" selected="">Select</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?= esc($product->id) ?>"><?= esc($product->name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<select name="supplier_${counter}" class="form-control custom-select supplier">
                                <option value="" selected="">Select</option>
                                <?php foreach ($suppliers as $supplier): ?>
                                    <option value="<?= esc($supplier->id) ?>"><?= esc($supplier->name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<input class="form-control quantity" type="number" name="quantity_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<input class="form-control purchase_price" type="text" name="purchase_price_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td>
                        	<input class="form-control selling_price" type="text" name="selling_price_${counter}">
                            <div class="invalid-feedback"></div>
                        </td>
                        <td><input class="form-control remark" type="text" name="remark_${counter}"></td>
                        <td>
                        	<a href="javascript:void(0)" class="btn btn-danger btn-xs remove-row-btn" data-remove-btn="purchase-row-${counter}">
		                		<i class="fa fa-times font-14"></i>
		                	</a>
                        </td>
                    </tr>
                `);
            });
            
            $('form .purchase-tbody').on('click', '.remove-row-btn', function() {
                var remove_id = $(this).data('remove-btn');
                $('#' + remove_id).remove();
            });
        });
    </script>
<?php endsection() ?>