<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product purchase edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="purchase-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('purchase.index')) ?>"><i class="fa fa-list"></i> Purchase List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Purchase</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="purchase-form">
                <div class="tab-content">
                    <div class="tab-pane show active" id="edit">
                    	<form action="<?= esc(route('purchase.update', [$purchase->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Purchase Date</label>
		                                <input class="form-control" type="date" name="date" value="<?= esc($purchase->date) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Batch Code<span class="text-danger">*</span></label>
		                                <input name="batch_code" type="text" class="form-control" value="<?= esc($purchase->batch_code) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div><div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Product<span class="text-danger">*</span></label>
		                                <select name="product" class="form-control custom-select">
		                                	<option value="<?= esc($purchase->product->id) ?>" selected><?= esc($purchase->product) ?></option>
		                                	<?php foreach ($products as $product): ?>
		                                		<option value="<?= esc($product->id) ?>"><?= esc($product) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Supplier</label>
		                                <select name="supplier" class="form-control custom-select">
		                                	<option value="<?= esc($purchase->supplier->id ?? "") ?>" selected><?= esc($purchase->supplier ?? "Select") ?></option>
		                                	<?php foreach ($suppliers as $supplier): ?>
		                                		<option value="<?= esc($supplier->id) ?>"><?= esc($supplier) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="number" name="quantity" value="<?= esc($purchase->quantity) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Purchase Price</label>
		                                <input class="form-control" type="text" name="purchase_price" value="<?= esc($purchase->purchase_price) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Selling Price<span class="text-danger">*</span></label>
		                                <input name="selling_price" type="text" class="form-control" value="<?= esc($purchase->selling_price) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <input class="form-control" type="text" name="remark" value="<?= esc($purchase->remark) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>