<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Invoice
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="invoice-ibox">
            <div class="ibox-head">
            	<div class="ibox-title"><i class="fa fa-list"></i> Invoice List</div>
                <div class="ibox-tools">
                    <!-- <a href="<?//= esc(route('invoice.add')) ?>">
                        <button class="btn btn-primary btn-sm">
                            <i class="fa fa-plus"></i> Add Invoice
                        </button>
                    </a> -->
                </div>
            </div>
            <div class="ibox-body dt-show" id="invoice-form">
            	<table class="table table-sm table-bordered table-hover table-responsive-sm data-table" id="invoice-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Invoice Number</th>
                            <th>Date</th>
                            <th>Amount</th>
                            <th>Paid</th>
                            <th>Balance</th>
                            <th>Discount</th>
                            <th>Customer</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoices as $invoice): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td>#<?= esc($invoice->bill_code) ?></td>
                                <td><?= esc($invoice->date) ?></td>
                                <td><?= esc($invoice->amount) ?></td>
                                <td><?= esc($invoice->paid) ?></td>
                                <td><?= esc($invoice->balance) ?></td>
                                <td><?= esc($invoice->discount) ?></td>
                                <td><?= esc($invoice->customer) ?></td>
                                <td>
                                    <a href="<?= esc(route('invoice.detail', [$invoice->id, $invoice->bill_code])) ?>" class="btn btn-default btn-xs m-r-5" title="View"><i class="fa fa-eye font-14"></i></a>
                                    <!-- <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#add-pay-<?= esc($invoice->id) ?>" title="App pay"><i class="fa fa-plus font-14"></i></button> -->
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#invoice-del-<?= esc($invoice->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="invoice-del-<?= esc($invoice->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete invoice</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('invoice.delete', [$invoice->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($invoice->bill_code) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                                <div class="modal fade" id="add-pay-<?= esc($invoice->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content rounded">
                                            <div class="modal-header">
                                                <h4 class="modal-title"><i class="fa fa-edit"></i> Add  Payment</h4>
                                                <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?= esc(route('payment.create')) ?>" method="POST" class="create-form">
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Invoice No</label>
                                                                <input type="hidden" name="invoice" value="<?= esc($invoice->id) ?>">
                                                                <input type="text" class="form-control" name="" value="<?= esc($invoice->bill_code) ?>" readonly>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Amount<span class="text-danger">*</span></label>
                                                                <input class="form-control payment-amount" type="text" name="amount">
                                                                <div class="invalid-feedback"></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Date<span class="text-danger">*</span></label>
                                                                <input class="form-control payment-date" type="date" name="date">
                                                                <div class="invalid-feedback"></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Payment Mode<span class="text-danger">*</span></label>
                                                                <select name="payment_mode" class="form-control custom-select payment-mode" id="payment-mode">
                                                                    <?php foreach ($payment_modes as $payment_mode): ?>
                                                                        <option value="<?= esc($payment_mode->id) ?>"<?php if (strtolower($payment_mode->via) == 'cash'): ?> selected<?php endif ?>>
                                                                            <?= esc($payment_mode->via) ?>
                                                                        </option>
                                                                    <?php endforeach ?>
                                                                </select>
                                                                <div class="invalid-feedback"></div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Balance</label>
                                                                <input type="text" class="form-control invoice-balance" name="balance" value="<?= esc($invoice->balance) ?>" readonly>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                                                        <button class="btn btn-primary rounded" type="submit">Add Payment</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>