<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Invoice 
<?php endsection() ?>
<?php section('content') ?>
<div class="row mb-5">
    <div class="col-md-12">
        <div class="ibox invoice">
            <div id="print-content">
                <div class="invoice-header">
                    <div class="row">
                        <div class="col-6">
                            <div class="invoice-logo">
                                <img src="<?= esc(source('image.company', $general_setting->logo)) ?>" alt="Logo" height="65px" />
                            </div>
                        </div>
                        <div class="col-6 text-right">
                            <div class="clf" style="margin-bottom:30px;">
                            <?php $date = explode('-', $invoice->date) ?>
                            <?php $invoice_date = $date[2].' '.jdmonthname(gregoriantojd($date[1], $date[2], $date[0]), 0).' '.$date[0] ?>
                                <dl class="row pull-right" style="width:250px;"><dt class="col-sm-6">Invoice No:</dt>
                                    <dd class="col-sm-6">#<?= esc($invoice->bill_code) ?></dd><dt class="col-sm-6">Invoice Date:</dt>
                                    <dd class="col-sm-6"><?= esc($invoice_date) ?></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div>
                                <div class="m-b-5 font-bold">Invoice from</div>
                                <div><?= esc($general_setting->name) ?></div>
                                <ul class="list-unstyled m-t-10">
                                    <li class="m-b-5"><?= esc($general_setting->address) ?></li>
                                    <li class="m-b-5"><?= esc($general_setting->email) ?></li>
                                    <li><?= esc($general_setting->phone) ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-6 text-right">
                            <div>
                                <div class="m-b-5 font-bold">Invoice To</div>
                                <div><?= esc($invoice->customer) ?></div>
                                <ul class="list-unstyled m-t-10">
                                    <li class="m-b-5"><?= esc($invoice->customer->address) ?></li>
                                    <li class="m-b-5"><?= esc($invoice->customer->email) ?></li>
                                    <li><?= esc($invoice->customer->phone) ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $sales = $invoice->sales->all() ?>
                    <div class="col-md-12">
                        <!-- <h5 class="m-t-10 m-b-10 font-strong">Allowance</h5> -->
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Products</th>
                                    <th>Unit Price (₦)</th>
                                    <th>Quantity</th>
                                    <th>Total Price (₦)</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($sales as $sale): ?>
                                <tr>
                                    <td><?= esc(counter()) ?></td>
                                    <td><?= esc($sale->inventory->product) ?></td>
                                    <td><?= esc($sale->unit_price) ?></td>
                                    <td><?= esc($sale->quantity) ?></td>
                                    <td><?= esc($sale->total_price) ?></td>
                                </tr>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <table class="table no-border">
                    <thead>
                        <tr>
                            <th></th>
                            <th width="15%"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-right">
                            <td>Total Amount:</td>
                            <td>₦<?= esc($invoice->sales->sum('total_price')) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Discount:</td>
                            <td>₦<?= esc($invoice->discount) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Grand Total:</td>
                            <td>₦<?= esc($invoice->amount) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Total Paid:</td>
                            <td>₦<?= esc($invoice->paid) ?></td>
                        </tr>
                        <tr class="text-right">
                            <td>Balance:</td>
                            <td>₦<?= esc($invoice->balance) ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="text-right">
                <button class="btn btn-info" type="button" onclick="printpage('print-content')"><i class="fa fa-print"></i> Print</button>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <?php $payments = $invoice->payments->all() ?>
    <div class="col-md-12">
        <div class="ibox invoice">
            <div id="print-payment-history">
                <h3 class="my-3 font-strong text-center">Payment History</h3>
                <div class="text-center mb-3">
                    <div><b>Customer: </b> &nbsp;<?= esc($invoice->customer) ?></div>
                    <div><b>Invoice No: </b> &nbsp;#<?= esc($invoice->bill_code) ?></div>
                </div>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>Date</th>
                            <th>Amount (₦)</th>
                            <th>Balance (₦)</th>
                            <th>Payment Method</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $sn = 0 ?>
                    <?php foreach ($payments as $payment): ?>
                        <tr>
                            <td><?= esc(++$sn) ?></td>
                            <td><?= esc($payment->date) ?></td>
                            <td><?= esc($payment->amount) ?></td>
                            <td><?= esc($payment->balance) ?></td>
                            <td><?= esc($payment->payment_mode) ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
            <div class="text-left">
                <button class="btn btn-info" type="button" data-toggle="modal" data-target="#add-pay"><i class="fa fa-money"></i> Add Payment</button>
            </div>
            <div class="text-right">
                <button class="btn btn-info" type="button" onclick="printpage('print-payment-history')"><i class="fa fa-print"></i> Print</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="add-pay" data-backdrop="static" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content rounded">
            <div class="modal-header">
                <h4 class="modal-title"><i class="fa fa-edit"></i> Add  Payment</h4>
                <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <div class="modal-body">
                <form action="<?= esc(route('payment.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <input type="hidden" name="invoice" value="<?= esc($invoice->id) ?>">
                                <label>Amount<span class="text-danger">*</span></label>
                                <input class="form-control payment-amount" type="text" name="amount">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Date<span class="text-danger">*</span></label>
                                <input class="form-control payment-date" type="date" name="date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Payment Mode<span class="text-danger">*</span></label>
                                <select name="payment_mode" class="form-control custom-select payment-mode" id="payment-mode">
                                    <?php foreach ($payment_modes as $payment_mode): ?>
                                        <option value="<?= esc($payment_mode->id) ?>"<?php if (strtolower($payment_mode->via) == 'cash'): ?> selected<?php endif ?>>
                                            <?= esc($payment_mode->via) ?>
                                        </option>
                                    <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Balance</label>
                                <input type="hidden" class="old-balance" value="<?= esc($invoice->balance) ?>">
                                <input type="text" class="form-control new-balance" name="balance" value="<?= esc($invoice->balance) ?>" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                        <button class="btn btn-primary rounded" type="submit">Add Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>