<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="product-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Product List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Product</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="product-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="product-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Name</th>
		                            <th>Code</th>
		                            <th>Category</th>
		                            <th>Unit</th>
		                            <th>Size</th>
		                            <th>Type</th>
		                            <th>Pack</th>
		                            <th>Price</th>
		                            <th>Brand</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($products as $product): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($product->name) ?></td>
		                                <td><?= esc($product->code) ?></td>
		                                <td><?= esc($product->category) ?></td>
		                                <td><?= esc($product->unit) ?></td>
		                                <td><?= esc($product->size) ?></td>
		                                <td><?= esc($product->type) ?></td>
		                                <td><?= esc($product->pack) ?></td>
		                                <td><?= esc($product->price) ?></td>
		                                <td><?= esc($product->brand) ?></td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($product->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('product.edit', [$product->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($product->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($product->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Product</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('product.delete', [$product->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($product) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('product.create')) ?>" method="POST" class="create-form" enctype="multipart/form-data">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="name">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Category<span class="text-danger">*</span></label>
		                                <select name="category" class="form-control custom-select">
		                                	<option value="">Select</option>
		                                	<?php foreach ($categorys as $category): ?>
		                                		<option value="<?= esc($category->id) ?>"><?= esc($category) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Type</label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="">Select</option>
		                                	<?php foreach ($types as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Code</label>
		                                <input class="form-control" type="text" name="code">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Unit</label>
		                                <select name="unit" class="form-control custom-select">
		                                	<option value="">Select</option>
		                                	<?php foreach ($units as $unit): ?>
		                                		<option value="<?= esc($unit->id) ?>"><?= esc($unit) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Size</label>
		                                <input class="form-control" type="text" name="size">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Pack</label>
		                                <input class="form-control" type="text" name="pack">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Price</label>
		                                <input class="form-control" type="text" name="price">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Brand</label>
		                                <select name="brand" class="form-control custom-select">
		                                	<option value="">Select</option>
		                                	<?php foreach ($brands as $brand): ?>
		                                		<option value="<?= esc($brand->id) ?>"><?= esc($brand) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Image</label>
		                                <input name="image" type="file" class="dropify" data-height="40">
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Note</label>
		                                <textarea class="form-control" name="note"></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>