<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Product Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="product-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('product.index')) ?>"><i class="fa fa-list"></i> Product List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Product</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="product-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('product.update', [$product->id])) ?>?_method=PUT" method="POST" class="update-form" enctype="multipart/form-data">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="name" value="<?= esc($product->name) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Category<span class="text-danger">*</span></label>
		                                <select name="category" class="form-control custom-select">
		                                	<option value="<?= esc($product->category->id) ?>" selected><?= esc($product->category) ?></option>
		                                	<?php foreach ($categorys as $category): ?>
		                                		<option value="<?= esc($category->id) ?>"><?= esc($category) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Code</label>
		                                <input class="form-control" type="text" name="code" value="<?= esc($product->code) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Unit</label>
		                                <select name="unit" class="form-control custom-select">
		                                	<option value="<?= esc($product->unit->id ?? "") ?>" selected><?= esc($product->unit ?? "Select") ?></option>
		                                	<?php foreach ($units as $unit): ?>
		                                		<option value="<?= esc($unit->id) ?>"><?= esc($unit) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Size</label>
		                                <input class="form-control" type="text" name="unit" value="<?= esc($product->unit) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Type</label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="<?= esc($product->type->id ?? "") ?>" selected><?= esc($product->type ?? "Select") ?></option>
		                                	<?php foreach ($types as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Pack</label>
		                                <input class="form-control" type="text" name="code" value="<?= esc($product->pack) ?>">
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Price</label>
		                                <input class="form-control" type="text" name="code" value="<?= esc($product->price) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Brand</label>
		                                <select name="brand" class="form-control custom-select">
		                                	<option value="<?= esc($product->brand->id ?? "") ?>" selected><?= esc($product->brand ?? "Select") ?></option>
		                                	<?php foreach ($brands as $brand): ?>
		                                		<option value="<?= esc($brand->id) ?>"><?= esc($brand) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Image</label>
		                                <input name="image" type="file" class="dropify" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('image.product', $product->image)) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Note</label>
		                                <textarea class="form-control" name="note"><?= esc($product->note) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>