<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Material List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="material-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Material List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Material</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="material-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="material-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Title</th>
		                            <th>Type</th>
		                            <th>Class</th>
		                            <th>Subject</th>
		                            <th>Author</th>
		                            <th>Doc Type</th>
		                            <th>document</th>
		                            <th>Remark</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($materials as $material): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <!-- <td>
		                                	<img src="<?//= esc(source('image.material', $material->image)) ?>" alt="material-image" height="30">
		                                </td> -->
		                                <td><?= esc($material->title) ?></td>
		                                <td><?= esc($material->type) ?></td>
		                                <td><?= esc($material->klass) ?></td>
		                                <td><?= esc($material->subject) ?></td>
		                                <td><?= esc($material->author) ?></td>
		                                <td><?= esc($material->doctype) ?></td>
		                                <td><?= esc($material->document) ?></td>
		                                <td><?= esc($material->remark) ?></td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($material->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('material.edit', [$material->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($material->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($material->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Material</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('material.delete', [$material->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($material) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('material.create')) ?>" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Title<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="title">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Class<span class="text-danger">*</span></label>
		                                <select name="klass" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($klasses as $klass): ?>
		                                		<option value="<?= esc($klass->id) ?>"><?= esc($klass) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Subject<span class="text-danger">*</span></label>
		                                <select name="subject" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($subjects as $subject): ?>
		                                		<option value="<?= esc($subject->id) ?>"><?= esc($subject) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($materialtypes as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Doc Type</label>
	                                    <input class="form-control" type="text" name="doctype">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Document</label>
	                                    <input class="dropify" type="file" name="document" data-height="20" data-max-file-size="2M">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <textarea class="form-control" name="remark"></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>