<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Material Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="material-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('material.index')) ?>"><i class="fa fa-list"></i> Material List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Material</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="material-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
                    	<form action="<?= esc(route('material.update', [$material->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Title<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="title" value="<?= esc($material->title) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Class<span class="text-danger">*</span></label>
		                                <select name="klass" class="form-control custom-select">
		                                	<option value="<?= esc($material->klass->id) ?>" selected><?= esc($material->klass) ?></option>
		                                	<?php foreach ($klasses as $klass): ?>
		                                		<option value="<?= esc($klass->id) ?>"><?= esc($klass) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Subject<span class="text-danger">*</span></label>
		                                <select name="subject" class="form-control custom-select">
		                                	<option value="<?= esc($material->subject->id) ?>" selected><?= esc($material->subject) ?></option>
		                                	<?php foreach ($subjects as $subject): ?>
		                                		<option value="<?= esc($subject->id) ?>"><?= esc($subject) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="<?= esc($material->type->id) ?>" selected><?= esc($material->type) ?></option>
		                                	<?php foreach ($materialtypes as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Doc Type</label>
	                                    <input class="form-control" type="text" name="doctype" value="<?= esc($material->doctype) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Document</label>
	                                    <input class="dropify" type="file" name="document" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('file.material', $material->document)) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <textarea class="form-control" name="remark"><?= esc($material->remark) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>