<?php include_section('admin/invoice/header') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox invoice">
        	<div id="print-content">
                <div class="row">
                    <div class="col-6">
                        <div class="invoice-logo">
                            <!-- <img src="/img/logos/logo-vue.png" style="height:65px" /> -->
                        </div>
                    </div>
                    <div class="col-6 text-right">
                        <div class="clf" style="margin-bottom:30px;">
                            <div class="row pull-right" style="width:250px;">
                            	<div class="col-sm-6">Invoice No</div><div class="col-sm-6">#<?= mt_rand(1000, 9999) ?></div>
                                <div class="col-sm-6">Issue Date</div><div class="col-sm-6"><?= date("d M Y") ?></div>
                                <div class="col-sm-6">Status</div><div class="col-sm-6"><span class="badge badge-danger">Pending</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <div>
                            <div class="m-b-5 font-bold">Invoice from</div>
                            <div>Smart College</div>
                            <ul class="list-unstyled m-t-10">
                                <li class="m-b-5">Curve, Oyigbo, Rivers State</li>
                                <li class="m-b-5">support@smart-college.co</li>
                                <li>+234-0813-580-5584</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-6 text-right">
                        <div>
                            <div class="m-b-5 font-bold">Invoice To</div>
                            <div><?= esc($student) ?></div>
                            <ul class="list-unstyled m-t-10">
                                <li class="m-b-5"><?= esc($student->address) ?></li>
                                <li class="m-b-5"><?= esc($student->email) ?></li>
                                <li><?= esc($student->phone) ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <table class="table table-hover no-margin table-invoice">
                <thead>
                    <tr>
                        <th>Fee Type</th>
                        <th>Amount(₦)</th>
                        <th>Due Date</th>
                        <th>Paid(₦)</th>
                        <th>Status</th>
                        <th class="text-right">Balance(₦)</th>
                    </tr>
                </thead>
                <tbody>
                	<?php $grand_total = 0 ?>
                	<?php foreach ($fees as $fee): ?>
                		<tr class="bg-grey-50 font-strong">
                			<th><?= esc($fee->fee_group->fee_type) ?> <i class="fa fa-chevron-down"></i></th>
                            <td><?= esc($fee->amount) ?></td>
                            <td><?= esc($fee->fee_group->due_date) ?></td>
                            <td><?= esc($fee->paid) ?></td>
                            <td>
                            	<?php if ($fee->status == 'pending'): ?>
                    				<span class="badge badge-danger"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php elseif ($fee->status == 'part'): ?>
                    				<span class="badge badge-warning"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php elseif ($fee->status == 'paid'): ?>
                    				<span class="badge badge-success"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php endif ?>
                            </td>
                            <td><?= esc($fee->balance) ?></td>
                		</tr>
                		<?php 
                			$fee_details = $fee->fee_group->fee_details->all() ; 
                			$fee_details_total = $fee->fee_group->fee_details->sum('amount');
                			$grand_total += $fee_details_total;
                		 ?>
                		<?php foreach ($fee_details as $fdetail): ?>
                		<tr>
                            <td><div><strong><?= esc($fdetail->name) ?></strong></div></td>
                            <td><?= esc($fdetail->amount) ?></td>
                        </tr>
                        <?php endforeach ?>
                	<?php endforeach ?>
                </tbody>
            </table>
            <table class="table no-border">
                <thead>
                    <tr>
                        <th></th>
                        <th width="15%"></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="text-right">
                        <td>Paid:</td>
                        <td>₦<?= esc($paid) ?></td>
                    </tr>
                    <tr class="text-right">
                        <td>Balance:</td>
                        <td>₦<?= esc($balance) ?></td>
                    </tr>
                    <tr class="text-right">
                        <td class="font-bold font-18">Grand Total:</td>
                        <td class="font-bold font-18">₦<?= esc($grand_total) ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include_section('admin/invoice/footer') ?>