<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Supplier Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="supplier-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('supplier.index')) ?>"><i class="fa fa-list"></i> Supplier List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Supplier</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="supplier-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('supplier.update', [$supplier->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="name" value="<?= esc($supplier->name) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Company</label>
		                                <input class="form-control" type="text" name="company" value="<?= esc($supplier->company) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Email</label>
		                                <input class="form-control" type="email" name="email" value="<?= esc($supplier->email) ?>">
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Phone<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="phone" value="<?= esc($supplier->phone) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Address</label>
		                                <textarea class="form-control" name="address"><?= esc($supplier->address) ?></textarea>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Note</label>
		                                <textarea class="form-control" name="note"><?= esc($supplier->note) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>