<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Store List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="store-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Store List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Store</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="store-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="store-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Name</th>
		                            <th>Code</th>
		                            <th>Type</th>
		                            <th>Manager</th>
		                            <th>Address</th>
		                            <th>Note</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($stores as $store): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($store->name) ?></td>
		                                <td><?= esc($store->code) ?></td>
		                                <td><?= esc($store->type) ?></td>
		                                <td><?= esc($store->manager) ?></td>
		                                <td><?= esc($store->address) ?></td>
		                                <td><?= esc($store->note) ?></td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($store->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('store.edit', [$store->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($store->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($store->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Store</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('store.delete', [$store->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($store) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('store.create')) ?>" method="POST" class="create-form">
		                    <div class="row">
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="name">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Code</label>
		                                <input class="form-control" type="text" name="code">
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Type</label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
	                                		<option value="Shop">Shop</option>
	                                		<option value="Warehouse">Warehouse</option>
		                                </select>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Manager</label>
		                                <select name="manager" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($managers as $manager): ?>
		                                		<option value="<?= esc($manager->id) ?>"><?= esc($manager) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Address</label>
		                                <textarea class="form-control" name="address" rows="2"></textarea>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Note</label>
		                                <textarea class="form-control" name="note" rows="2"></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>