<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Store Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="store-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('store.index')) ?>"><i class="fa fa-list"></i> Store List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Store</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="store-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('store.update', [$store->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="name" value="<?= esc($store->name) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Code</label>
		                                <input class="form-control" type="text" name="code" value="<?= esc($store->code) ?>">
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="<?= esc($store->type) ?>" selected><?= esc($store->type) ?></option>
	                                		<option value="Shop">Shop</option>
	                                		<option value="Warehouse">Warehouse</option>
		                                </select>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Manager<span class="text-danger">*</span></label>
		                                <select name="manager" class="form-control custom-select">
		                                	<option value="<?= esc($store->manager->id ?? '') ?>" selected><?= esc($store->manager ?? 'Select') ?></option>
		                                	<?php foreach ($managers as $manager): ?>
		                                		<option value="<?= esc($manager->id) ?>"><?= esc($manager) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Address</label>
		                                <textarea class="form-control" name="address"><?= esc($store->address) ?></textarea>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Note</label>
		                                <textarea class="form-control" name="note"><?= esc($store->note) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>