<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Stock List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="stock-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Stock List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Stock</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="stock-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="stock-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Stock</th>
		                            <th>Category</th>
		                            <th>Item</th>
		                            <th>Supplier</th>
		                            <th>Quantity</th>
		                            <th>Price</th>
		                            <th>Ref Number</th>
		                            <th>Date</th>
		                            <th>Expiry</th>
		                            <th>Description</th>
		                            <th>Image</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($stocks as $stock): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($stock->stock) ?></td>
		                                <td><?= esc($stock->category) ?></td>
		                                <td><?= esc($stock->item) ?></td>
		                                <td><?= esc($stock->supplier) ?></td>
		                                <td><?= esc($stock->quantity) ?></td>
		                                <td><?= esc($stock->price) ?></td>
		                                <td><?= esc($stock->ref_num) ?></td>
		                                <td><?= esc($stock->date) ?></td>
		                                <td><?= esc($stock->expiry) ?></td>
		                                <td><?= esc($stock->description) ?></td>
		                                <td>
		                                	<img src="<?= esc(source('image.stock', $stock->image)) ?>" alt="stock-image" height="30">
		                                </td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($stock->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('stock.edit', [$stock->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($stock->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($stock->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Stock</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('stock.delete', [$stock->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete this "<em>stock</em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('stock.create')) ?>" method="POST" class="save-edit-form">
		                    <div class="row">
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Store<span class="text-danger">*</span></label>
		                                <select name="store" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($stores as $store): ?>
		                                		<option value="<?= esc($store->id) ?>"><?= esc($store) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Item Category<span class="text-danger">*</span></label>
		                                <select name="category" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($categories as $category): ?>
		                                		<option value="<?= esc($category->id) ?>"><?= esc($category) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Item<span class="text-danger">*</span></label>
		                                <select name="item" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($items as $item): ?>
		                                		<option value="<?= esc($item->id) ?>"><?= esc($item) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Supplier<span class="text-danger">*</span></label>
		                                <select name="supplier" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($suppliers as $supplier): ?>
		                                		<option value="<?= esc($supplier->id) ?>"><?= esc($supplier) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="quantity">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Price<span class="text-danger">*</span></label>
		                                <input class="form-control" type="number" name="price">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Ref Number</label>
		                                <input class="form-control" type="text" name="ref_num">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Date</label>
		                                <input class="form-control" type="date" name="date">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Expiry</label>
		                                <input class="form-control" type="text" name="expiry">
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Image</label>
		                                <input class="dropify" type="file" name="image" data-height="20" data-max-file-size="2M">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Decription</label>
		                                <textarea class="form-control" name="description" rows="2"></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>