<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Stock Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="stock-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('stock.index')) ?>"><i class="fa fa-list"></i> Stock List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Stock</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="stock-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('stock.update', [$stock->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Store
		                                <div class="invalid-feedback"></div></label>
		                                <select name="store" class="form-control custom-select">
		                                	<option value="<?= esc($stock->store->id) ?>" selected><?= esc($stock->store) ?></option>
		                                	<?php foreach ($stores as $store): ?>
		                                		<option value="<?= esc($store->id) ?>"><?= esc($store) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Item Category
		                                <div class="invalid-feedback"></div></label>
		                                <select name="category" class="form-control custom-select">
		                                	<option value="<?= esc($stock->category->id) ?>" selected><?= esc($stock->category) ?></option>
		                                	<?php foreach ($categories as $category): ?>
		                                		<option value="<?= esc($category->id) ?>"><?= esc($category) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Item
		                                <div class="invalid-feedback"></div></label>
		                                <select name="item" class="form-control custom-select">
		                                	<option value="<?= esc($stock->item->id) ?>" selected><?= esc($stock->item) ?></option>
		                                	<?php foreach ($items as $item): ?>
		                                		<option value="<?= esc($item->id) ?>"><?= esc($item) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Supplier
		                                <div class="invalid-feedback"></div></label>
		                                <select name="supplier" class="form-control custom-select">
		                                	<option value="<?= esc($stock->supplier->id) ?>" selected><?= esc($stock->supplier) ?></option>
		                                	<?php foreach ($suppliers as $supplier): ?>
		                                		<option value="<?= esc($supplier->id) ?>"><?= esc($supplier) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="quantity" value="<?= esc($stock->quantity) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Price<span class="text-danger">*</span></label>
		                                <input class="form-control" type="number" name="price" value="<?= esc($stock->price) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Ref Number</label>
		                                <input class="form-control" type="text" name="ref_num" value="<?= esc($stock->ref_num) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Date</label>
		                                <input class="form-control" type="date" name="date" value="<?= esc($stock->date) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Expiry</label>
		                                <input class="form-control" type="text" name="expiry" value="<?= esc($stock->expiry) ?>">
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Image</label>
		                                <input class="dropify" type="file" name="image" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('image.stock', $stock->image)) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Decription</label>
		                                <textarea class="form-control" name="description" rows="2"><?= esc($stock->description) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>