<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Issue Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="issue-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('issue.index')) ?>"><i class="fa fa-list"></i> Issue List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Issue</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="issue-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('issue.update', [$issue->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Category<span class="text-danger">*</span></label>
		                                <select name="category" class="form-control custom-select">
		                                	<option value="<?= esc($issue->category->id) ?>" selected><?= esc($issue->category) ?></option>
		                                	<?php foreach ($categories as $category): ?>
		                                		<option value="<?= esc($category->id) ?>"><?= esc($category) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Item<span class="text-danger">*</span></label>
		                                <select name="item" class="form-control custom-select">
		                                	<option value="<?= esc($issue->item->id) ?>" selected><?= esc($issue->item) ?></option>
		                                	<?php foreach ($items as $item): ?>
		                                		<option value="<?= esc($item->id) ?>"><?= esc($item) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Issue To<span class="text-danger">*</span></label>
		                                <select name="issue_to" class="form-control custom-select">
		                                	<option value="<?= esc($issue->issued_to->id) ?>" selected><?= esc($issue->issued_to) ?></option>
		                                	<?php foreach ($users as $user): ?>
		                                		<option value="<?= esc($user->id) ?>"><?= esc($user) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Quantity<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="quantity" value="<?= esc($issue->quantity) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Issue Date</label>
		                                <input class="form-control" type="date" name="issue_date" value="<?= esc($issue->issue_date) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Remark</label>
		                                <textarea class="form-control" name="remark"><?= esc($issue->remark) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>