<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Event List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="event-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Event List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Event</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="event-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="event-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Title</th>
		                            <th>Type</th>
		                            <th>Venue</th>
		                            <th>Start Date</th>
		                            <th>Close Date</th>
		                            <th>Description</th>
		                            <th>Image</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($events as $event): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($event->title) ?></td>
		                                <td><?= esc($event->type) ?></td>
		                                <td><?= esc($event->venue) ?></td>
		                                <td><?= esc($event->start_date) ?></td>
		                                <td><?= esc($event->close_date) ?></td>
		                                <td><?= esc($event->description) ?></td>
		                                <td>
		                                	<img src="<?= esc(source('image.event', $event->image)) ?>" alt="event-banner" height="30">
		                                </td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($event->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('event.edit', [$event->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($event->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($event->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Event</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('event.delete', [$event->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($event) ?></em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('event.create')) ?>" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Title<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="title">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Venue</label>
		                                <input class="form-control" type="text" name="venue">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                	<?php foreach ($types as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Image</label>
	                                    <input class="dropify" type="file" name="image" data-height="20" data-max-file-size="2M">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Start Date</label>
		                                <input class="form-control" type="date" name="start_date">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Close Date</label>
	                                    <input class="form-control" type="date" name="close_date">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Description</label>
		                                <textarea class="form-control" name="description"></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>