<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Event Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="event-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('event.index')) ?>"><i class="fa fa-list"></i> Event List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Event</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="event-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('event.update', [$event->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Title<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="title" value="<?= esc($event->title) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Venue</label>
		                                <input class="form-control" type="text" name="venue" value="<?= esc($event->venue) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-3">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <select name="type" class="form-control custom-select">
		                                	<option value="<?= esc($event->type->id) ?>" selected><?= esc($event->type) ?></option>
		                                	<?php foreach ($types as $type): ?>
		                                		<option value="<?= esc($type->id) ?>"><?= esc($type) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Image</label>
	                                    <input class="dropify" type="file" name="image" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('image.event', $event->image)) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Start Date</label>
		                                <input class="form-control" type="date" name="start_date" value="<?= esc($event->start_date) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Close Date</label>
	                                    <input class="form-control" type="date" name="close_date" value="<?= esc($event->close_date) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Description</label>
		                                <textarea class="form-control" name="description"><?= esc($event->description) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>