<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
SMS Config List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="sms-config-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('sms.config.index')) ?>"><i class="fa fa-list"></i> SMS Config List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Edit SMS Config</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="sms-config-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="add">
                    	<form action="<?= esc(route('sms.config.update', [$sms_config->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Type<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="type" value="<?= esc($sms_config->type) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Name<span class="text-danger">*</span></label>
		                                <input type="text" name="name" class="form-control" value="<?= esc($sms_config->name) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>API ID<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="api_id" value="<?= esc($sms_config->api_id) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Auth Key<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="auth_key" value="<?= esc($sms_config->auth_key) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
	                        </div>
	                        <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Sender ID<span class="text-danger">*</span></label>
	                                    <input class="form-control" type="text" name="sender_id" value="<?= esc($sms_config->sender_id) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>URL</label>
		                                <input name="url" class="form-control" type="url" value="<?= esc($sms_config->url) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Contact</label>
		                                <input class="form-control" type="text" name="contact" value="<?= esc($sms_config->contact) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Username</label>
	                                    <input class="form-control" type="text" name="username" value="<?= esc($sms_config->username) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Password</label>
		                                <input class="form-control" type="text" name="password" value="<?= esc($sms_config->password) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>