<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Send Email
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Send Email</div>
                <div class="ibox-tools">
                	<span class="font-bold">Send To <i class="fa fa-arrow-right mx-2"></i></span>
                    <button class="btn btn-default mr-2 active" type="button" id="send-group">Group</button>
                    <button class="btn btn-outline-default mr-2" type="button" id="send-individual">Individual</button>
                    <button class="btn btn-outline-default" type="button" id="send-klass">Class</button>
                </div>
            </div>
            <div class="ibox-body" id="email-send-form">
                <form action="<?= esc(route('email.send')) ?>" method="POST" class="message-form">
                	<div class="row">
					    <div class="col-md-8">
					        <div class="row">
		                        <div class="col-md-12">
		                            <div class="form-group">
		                                <label>Template</label>
		                                <select name="template" class="form-control custom-select">
		                                	<option value="">Select</option>
		                                    <?php foreach ($email_templates as $email_template): ?>
		                                        <option value="<?= $email_template->subject ?>|<?= $email_template->message ?>">
		                                        	<?= $email_template->subject ?>
		                                        </option>
		                                    <?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-12">
		                            <div class="form-group">
		                                <label>Subject<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="subject">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-12">
		                            <div class="form-group">
		                                <label>Message<span class="text-danger">*</span></label>
		                                <textarea class="form-control" name="message" id="summernote"></textarea>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-12">
		                            <div class="form-group">
		                                <label>Attachment</label>
		                                <input class="dropify" type="file" name="attachment" data-height="80" data-max-file-size="2M">
		                            </div>
		                        </div>
		                    </div>
					    </div>
					    <div class="col-md-4" id="send-to">
					    	<div class="row" id="group-input">
					    		<div class="col-md-12">
	                            	<div class="form-group">
	                                	<label>Role<span class="text-danger">*</span></label>
		                                <select name="roles[]" class="form-control select2_demo_2" style="width:100%" multiple>
		                                    <?php foreach ($roles as $role): ?>
		                                        <option value="<?= $role->id ?>"><?= $role->name ?></option>
		                                    <?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
					            <!-- <div class="col-md-12">
					            	<div class="form-group">
					            		<label class="ui-checkbox ui-checkbox-primary">
                                            <input type="checkbox" id="role-all">
                                            <span class="input-span"></span>Select All
                                        </label>
					            	</div>
					            </div> -->
					    	</div>
	                        <div class="row" id="individual-input">
	                        	<div class="col-md-12">
					            	<div class="form-group">
					                	<label>Role<span class="text-danger">*</span></label>
					                    <select name="role" class="form-control custom-select">
					                        <?php foreach ($roles as $role): ?>
					                            <option value="<?= $role->id ?>"><?= $role->name ?></option>
					                        <?php endforeach ?>
					                    </select>
					                    <div class="invalid-feedback"></div>
					                </div>
					            </div>
					            <div class="col-md-12">
					            	<div class="form-group">
					                	<label>User<span class="text-danger">*</span></label>
					                    <select name="users[]" class="form-control select2_demo_2" style="width:100%" multiple>
				                            <option value="">Select Role First</option>
					                    </select>
					                    <div class="invalid-feedback"></div>
					                </div>
					            </div>
					            <!-- <div class="col-md-12">
					            	<div class="form-group">
					            		<label class="ui-checkbox ui-checkbox-primary">
                                            <input type="checkbox" id="user-all">
                                            <span class="input-span"></span>Select All
                                        </label>
					            	</div>
					            </div> -->
	                        </div>
	                        <div class="row" id="klass-input">
	                        	<div class="col-md-12">
					            	<div class="form-group">
					                	<label>Class<span class="text-danger">*</span></label>
					                    <select name="klass" class="form-control custom-select klass-field" data-url="<?= esc(route('section.select')) ?>?klass_id=">
					                    	<option value="">Select</option>
					                        <?php foreach ($klasses as $klass): ?>
					                            <option value="<?= $klass->id ?>"><?= $klass->name ?></option>
					                        <?php endforeach ?>
					                    </select>
					                    <div class="invalid-feedback"></div>
					                </div>
					            </div>
					            <div class="col-md-12">
					            	<div class="form-group">
					                	<label>Section<span class="text-danger">*</span></label>
					                    <select name="sections[]" class="form-control select2_demo_2 ksection" style="width:100%" multiple>
				                            <option value="">Select Class First</option>
					                    </select>
					                    <div class="invalid-feedback"></div>
					                </div>
					            </div>
					            <!-- <div class="col-md-12">
					            	<div class="form-group">
					            		<label class="ui-checkbox ui-checkbox-primary">
                                            <input type="checkbox" id="section-all">
                                            <span class="input-span"></span>Select All
                                        </label>
					            	</div>
					            </div> -->
	                        </div>
					    </div>
                	</div>
                    
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit"><i class="fa fa-send"></i> Send</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>