<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Email Config List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="email-config-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link active" href="#list" data-toggle="tab"><i class="fa fa-list"></i> Email Config List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Add Email Config</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="email-config-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="list">
                    	<table class="table table-sm table-bordered table-hover data-table" id="email-config-table" cellspacing="0" width="100%">
		                    <thead class="thead-light">
		                        <tr>
		                        	<th>#</th>
		                            <th>Gateway</th>
		                            <th>Email</th>
		                            <th>Protocol</th>
		                            <th>Encryption</th>
		                            <th>SMTP Host</th>
		                            <th>SMTP Username</th>
		                            <th>SMTP Password</th>
		                            <th>SMTP Port</th>
		                            <th>SMTP Auth</th>
		                            <th>Action</th>
		                        </tr>
		                    </thead>
		                    <tbody>
		                        <?php foreach ($email_configs as $email_config): ?>
		                            <tr>
		                            	<td><?= esc(counter()) ?></td>
		                                <td><?= esc($email_config->gateway) ?></td>
		                                <td><?= esc($email_config->email) ?></td>
		                                <td><?= esc($email_config->protocol) ?></td>
		                                <td><?= esc($email_config->encryption) ?></td>
		                                <td><?= esc($email_config->smtp_host) ?></td>
		                                <td><?= esc($email_config->smtp_user) ?></td>
		                                <td><?= esc($email_config->smtp_pass) ?></td>
		                                <td><?= esc($email_config->smtp_port) ?></td>
		                                <td><?= esc($email_config->smtp_auth) ?></td>
		                                <td>
		                                	<button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#veh-view-<?= esc($email_config->id) ?>" title="View"><i class="fa fa-bars font-14"></i></button>
		                                    <a href="<?= esc(route('email_config.edit', [$email_config->id])) ?>" class="btn btn-default btn-xs m-r-5" title="Edit"><i class="fa fa-pencil font-14"></i></a>
		                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($email_config->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
		                                </td>
		                               	<div class="modal fade" id="subj-del-<?= esc($email_config->id) ?>" tabindex="-1" aria-hidden="true">
										  	<div class="modal-dialog modal-dialog-centered">
											    <div class="modal-content rounded">
											      	<div class="modal-header">
												        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Email Config</h4>
												        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
											      	</div>
											      	<div class="modal-body">
												        <form action="<?= esc(route('email.config.delete', [$email_config->id])) ?>?_method=DELETE" method="POST" class="delete-form">
										                    <div>
										                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
										                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete this "<em>email config</em>"?</h4>
										                    	<p class="text-center">You may not be able to reverse this action.</p>
										                    </div>
										                    <div class="form-group d-flex justify-content-center mt-4">
										                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
										                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
										                    </div>
										                </form>
											      	</div>
											    </div>
										  	</div>
										</div>
		                            </tr>
		                        <?php endforeach ?>
		                    </tbody>
		                </table>
                    </div>
                    <div class="tab-pane" id="add">
                    	<form action="<?= esc(route('email.config.create')) ?>" method="POST" class="create-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Gateway</label>
		                                <input class="form-control" type="text" name="gateway">
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Email<span class="text-danger">*</span></label>
		                                <input type="email" name="email" class="form-control">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Host<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="smtp_host">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Username<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="smtp_user">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Password<span class="text-danger">*</span></label>
	                                    <input class="form-control" type="text" name="smtp_pass">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
	                        </div>
	                        <div class="row">
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>SMTP Port<span class="text-danger">*</span></label>
		                                <input name="smtp_port" class="form-control" type="text">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>SMTP Auth</label>
		                                <select name="smtp_auth" class="form-control custom-select">
		                                	<option value="" selected>Select</option>
		                                    <option value="1">Yes</option>
		                                    <option value="0">No</option>
		                                </select>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Protocol</label>
	                                    <input class="form-control" type="text" name="protocol">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Encryption<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="encryption">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>