<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Email Config List
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="email-config-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="#"><i class="fa fa-list"></i> Email Config List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#add" data-toggle="tab"><i class="fa fa-edit"></i> Edit Email Config</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="email-config-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="add">
                    	<form action="<?= esc(route('email.config.update', [$email_config->id])) ?>?_method=PUT" method="POST" class="update-form">
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Gateway</label>
		                                <input class="form-control" type="text" name="gateway" value="<?= esc($email_config->gateway) ?>">
		                            </div>
		                        </div>
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Email<span class="text-danger">*</span></label>
		                                <input type="email" name="email" class="form-control" value="<?= esc($email_config->email) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Host<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="smtp_host" value="<?= esc($email_config->smtp_host) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Username<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="smtp_user" value="<?= esc($email_config->smtp_user) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>SMTP Password<span class="text-danger">*</span></label>
	                                    <input class="form-control" type="text" name="smtp_pass" value="<?= esc($email_config->smtp_pass) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
	                        </div>
	                        <div class="row">
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>SMTP Port<span class="text-danger">*</span></label>
		                                <input name="smtp_port" class="form-control" type="text" value="<?= esc($email_config->smtp_port) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>SMTP Auth</label>
		                                <select name="smtp_auth" class="form-control custom-select">
		                                	<option value="<?= esc($email_config->smtp_auth) ?>" selected><?= esc($email_config->smtp_auth ? 'Yes' : 'No') ?></option>
		                                    <option value="1">Yes</option>
		                                    <option value="0">No</option>
		                                </select>
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Protocol</label>
	                                    <input class="form-control" type="text" name="protocol" value="<?= esc($email_config->protocol) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-3">
		                            <div class="form-group">
		                                <label>Encryption<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="encryption" value="<?= esc($email_config->encryption) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>