<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Fee Reminder
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Fee Reminder</div>
            </div>
            <div class="ibox-body" id="fee-reminder-form">
                <form action="<?= esc(route('fee_reminder.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Frequency<span class="text-danger">*</span></label>
                                <select name="frequency" class="form-control custom-select">
                                	<option value="" selected>Select</option>
                                    <option value="before">Before</option>
                                    <option value="after">After</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Days<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="days">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Message<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="message" rows="2"></textarea>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Notify</label>
                                <div class="m-b-20">
                                    <label class="ui-checkbox ui-checkbox-inline ui-checkbox-success">
                                        <input type="checkbox" name="guardian">
                                        <span class="input-span"></span>Guardian
                                    </label>
                                    <label class="ui-checkbox ui-checkbox-inline ui-checkbox-warning">
                                        <input type="checkbox" name="student">
                                        <span class="input-span"></span>Student
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="fee-reminder-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Fee Reminder List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="fee-reminder-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Frequency</th>
                            <th>Days</th>
                            <th>Notify</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($fee_reminders as $fee_reminder): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($fee_reminder->frequency) ?></td>
                                <td><?= esc($fee_reminder->days) ?></td>
                                <td>
                                	<div><?= esc($fee_reminder->guardian ? 'Guardian' : '') ?></div>
                                	<div><?= esc($fee_reminder->student ? 'Student' : '') ?></div>
                                </td>
                                <td>
                                    <a href="<?= esc(route('fee_reminder.index')) ?>?_id=<?= esc($fee_reminder->id) ?>" class="btn btn-default btn-xs m-r-5 fee-reminder-update" title="Edit"><i class="fa fa-pencil font-14"></i></a>
                                    <!-- <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#subj-edit-<//= esc($fee_reminder->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button> -->
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($fee_reminder->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="subj-del-<?= esc($fee_reminder->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Fee Reminder</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('fee_reminder.delete', [$fee_reminder->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em>this fee reminder</em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="subj-edit-<?= esc($fee_reminder->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Fee Reminder</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('fee_reminder.update', [$fee_reminder->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Frequency<span class="text-danger">*</span></label>
								                                <input class="form-control" type="text" name="frequency" value="<?= esc($fee_reminder->frequency) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Days</label>
								                                <input class="form-control" type="text" name="days" value="<?= esc($fee_reminder->days) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Message</label>
								                                <textarea class="form-control" name="message" rows="2"><?= esc($fee_reminder->message) ?></textarea>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Notify</label>
								                                <div class="m-b-20">
								                                    <label class="ui-checkbox ui-checkbox-inline ui-checkbox-primary">
								                                        <input type="checkbox" name="guardian">
								                                        <span class="input-span"></span>Guardian
								                                    </label>
								                                    <label class="ui-checkbox ui-checkbox-inline ui-checkbox-warning">
								                                        <input type="checkbox" name="student">
								                                        <span class="input-span"></span>Student
								                                    </label>
								                                </div>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>