<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Fee Group
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Fee Group</div>
            </div>
            <div class="ibox-body" id="feegroup-form">
                <form action="<?= esc(route('feegroup.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                        	<div class="form-group">
                                <label class="form-control-label">Fee Type<span class="text-danger">*</span></label>
                                <select name="fee_type" class="form-control custom-select">
                                    <option value="">Select</option>
                                	<?php foreach ($fee_types as $fee_type): ?>
                                    <option value="<?= esc($fee_type->id) ?>"><?= esc($fee_type) ?></option>
                                	<?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Due Date</label>
                                <input class="form-control ui-input-gray" type="date" name="due_date">
                            </div>
                        </div>
                        <div class="col-md-12">
                        	<div class="form-group">
                                <label class="form-control-label">Fee Detail<span class="text-danger">*</span></label>
                                <select name="feedetails[]" class="form-control select2_demo_2" style="width: 100%;" multiple>
                                    <optgroup label="Choose...">
                                    	<?php foreach ($feedetails as $feedetail): ?>
                                        <option value="<?= esc($feedetail->id) ?>"><?= esc($feedetail) ?></option>
                                    	<?php endforeach ?>
                                    </optgroup>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Remark</label>
                                <textarea class="form-control" name="remark" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group kb">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="feegroup-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Fee Group List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="feegroup-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Fee Type</th>
                            <th>Due Date</th>
                            <th>Amount</th>
                            <th>Fee Details</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($feegroups as $feegroup): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($feegroup->fee_type) ?></td>
                                <td><?= esc($feegroup->due_date) ?></td>
                                <td><?= esc($feegroup->feedetails->sum('amount')) ?></td>
                                <td>
                                	<?php if ($feegroup->feedetails->count() > 0): ?>
                                		<?php foreach ($feegroup->feedetails->all() as $feedetail): ?>
                                		<div><?= esc($feedetail) ?></div>
                                		<?php endforeach ?>
                                	<?php endif ?>
                                </td>
                                <td>
                                	<a href="<?= esc(route('feegroup.index')) ?>?_id=<?= esc($feegroup->id) ?>" class="btn btn-default btn-xs m-r-5 feegroup-update" title="Edit"><i class="fa fa-pencil font-14"></i></a>
                                    <!-- <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#sect-edit-<= esc($feegroup->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button> -->
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#sect-del-<?= esc($feegroup->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="sect-del-<?= esc($feegroup->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Fee Group</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('feegroup.delete', [$feegroup->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em>this fee group</em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="sect-edit-<?= esc($feegroup->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Fee Group</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('feegroup.update', [$feegroup->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label class="form-control-label">Fee Type</label>
								                                <select name="fee_type" class="form-control custom-select">
								                                	<option value="<?= esc($feegroup->fee_type->id) ?>" selected><?= esc($feegroup->fee_type) ?></option>
							                                    	<?php foreach ($fee_types as $fee_type): ?>
							                                        <option value="<?= esc($fee_type->id) ?>"><?= esc($fee_type) ?></option>
							                                    	<?php endforeach ?>
								                                </select>
								                            </div>
								                        </div>
								                        <div class="col-md-12 kn">
								                            <div class="form-group">
								                                <label>Due Date</label>
								                                <input class="form-control" type="date" name="due_date" value="<?= esc($feegroup->due_date) ?>">
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label class="form-control-label">Fee Details<span class="text-danger">*</span></label>
								                                <select name="feedetails[]" class="form-control select2_demo_1" style="width: 100%;" multiple>
								                                	<?php if ($feegroup->feedetails->count() > 0): ?>
								                                		<?php foreach ($feegroup->feedetails->all() as $feedetail): ?>
								                                		<option value="<?= esc($feedetail->id) ?>" selected><?= esc($feedetail) ?></option>
								                                		<?php endforeach ?>
								                                	<?php endif ?>
								                                    <optgroup label="Choose...">
								                                    	<?php foreach ($feedetails as $feedetail): ?>
								                                        <option value="<?= esc($feedetail->id) ?>"><?= esc($feedetail) ?></option>
								                                    	<?php endforeach ?>
								                                    </optgroup>
								                                </select>
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Remark</label>
								                                <textarea class="form-control" name="remark" rows="2"><?= esc($feegroup->remark) ?></textarea>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group kb">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>