<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Fee Discount
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Fee Discount</div>
            </div>
            <div class="ibox-body" id="fee-discount-form">
                <form action="<?= esc(route('fee_discount.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="name">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Code<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="code">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Type<span class="text-danger">*</span></label>
                                <select name="type" class="form-control custom-select">
                                	<option value="" selected>Select</option>
                                    <option value="percentage">Percentage</option>
                                    <option value="flat rate">Flat Rate</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Amount<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="amount">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Remark</label>
                                <textarea class="form-control" name="remark" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="fee-discount-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Fee Discount List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="fee-discount-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($fee_discounts as $fee_discount): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($fee_discount->name) ?></td>
                                <td><?= esc($fee_discount->code) ?></td>
                                <td><?= esc($fee_discount->type) ?></td>
                                <td><?= esc($fee_discount->amount) ?></td>
                                <td>
                                    <a href="<?= esc(route('fee_discount.index')) ?>?_id=<?= esc($fee_discount->id) ?>" class="btn btn-default btn-xs m-r-5 fee-discount-update" title="Edit"><i class="fa fa-pencil font-14"></i></a>
                                    <!-- <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#subj-edit-<//= esc($fee_discount->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button> -->
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($fee_discount->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="subj-del-<?= esc($fee_discount->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Fee Discount</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('fee_discount.delete', [$fee_discount->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($fee_discount) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="subj-edit-<?= esc($fee_discount->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Fee Discount</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('fee_discount.update', [$fee_discount->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Name<span class="text-danger">*</span></label>
								                                <input class="form-control" type="text" name="name" value="<?= esc($fee_discount->name) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Code</label>
								                                <input class="form-control" type="text" name="code" value="<?= esc($fee_discount->code) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Remark</label>
								                                <textarea class="form-control" name="remark" rows="2"><?= esc($fee_discount->remark) ?></textarea>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>