<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Fee Detail
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-edit"></i> Add Fee Detail</div>
            </div>
            <div class="ibox-body" id="feedetail-form">
                <form action="<?= esc(route('feedetail.create')) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Name<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="name">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Amount<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="amount">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" name="remark" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary rounded" type="submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="ibox" id="feedetail-ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-list"></i> Fee Detail List</div>
            </div>
            <div class="ibox-body dt-show">
                <table class="table table-sm table-bordered table-hover data-table" id="feedetail-table" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                        	<th>#</th>
                            <th>Name</th>
                            <th>Amount</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($feedetails as $feedetail): ?>
                            <tr>
                            	<td><?= esc(counter()) ?></td>
                                <td><?= esc($feedetail->name) ?></td>
                                <td><?= esc($feedetail->amount) ?></td>
                                <td><?= esc($feedetail->remark) ?></td>
                                <td>
                                    <a href="<?= esc(route('feedetail.index')) ?>?_id=<?= esc($feedetail->id) ?>" class="btn btn-default btn-xs m-r-5 feedetail-update" title="Edit"><i class="fa fa-pencil font-14"></i></a>
                                    <!-- <button type="button" class="btn btn-default btn-xs m-r-5" data-toggle="modal" data-target="#subj-edit-<//= esc($feedetail->id) ?>" title="Edit"><i class="fa fa-pencil font-14"></i></button> -->
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#subj-del-<?= esc($feedetail->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                               	<div class="modal fade" id="subj-del-<?= esc($feedetail->id) ?>" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog modal-dialog-centered">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-trash"></i> Delete Fee Detail</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('feedetail.delete', [$feedetail->id])) ?>?_method=DELETE" method="POST" class="delete-form">
								                    <div>
								                    	<h2 class="text-warning display-4 text-center"><i class="fa fa-exclamation-triangle"></i></h2>
								                    	<h4 class="font-weight-bold text-center">Are you sure you want to delete "<em><?= esc($feedetail) ?></em>"?</h4>
								                    	<p class="text-center">You may not be able to reverse this action.</p>
								                    </div>
								                    <div class="form-group d-flex justify-content-center mt-4">
								                    	<button type="button" class="btn btn-default rounded mr-2" data-dismiss="modal">Cancel</button>
								                        <button class="btn btn-danger rounded ml-2" type="submit">Delete</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
								<div class="modal fade" id="subj-edit-<?= esc($feedetail->id) ?>" data-backdrop="static" tabindex="-1" aria-hidden="true">
								  	<div class="modal-dialog">
									    <div class="modal-content rounded">
									      	<div class="modal-header">
										        <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Fee Detail</h4>
										        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal" onclick="location.href=location.href"><i class="fa fa-times"></i></button>
									      	</div>
									      	<div class="modal-body">
										        <form action="<?= esc(route('feedetail.update', [$feedetail->id])) ?>?_method=PUT" method="POST" class="update-form">
								                    <div class="row">
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Name<span class="text-danger">*</span></label>
								                                <input class="form-control" type="text" name="name" value="<?= esc($feedetail->name) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Amount</label>
								                                <input class="form-control" type="text" name="amount" value="<?= esc($feedetail->amount) ?>">
								                                <div class="invalid-feedback"></div>
								                            </div>
								                        </div>
								                        <div class="col-md-12">
								                            <div class="form-group">
								                                <label>Description</label>
								                                <textarea class="form-control" name="remark" rows="2"><?= esc($feedetail->remark) ?></textarea>
								                            </div>
								                        </div>
								                    </div>
								                    <div class="form-group">
								                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal" onclick="location.href=location.href">Cancel</button>
								                        <button class="btn btn-primary rounded" type="submit">Update</button>
								                    </div>
								                </form>
									      	</div>
									    </div>
								  	</div>
								</div>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endsection() ?>