<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Student Fee Collection
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-search"></i> Search Criteria</div>
            </div>
            <div class="ibox-body" id="fee-collect-filter">
                <form action="<?= esc(route('fee.collection')) ?>" method="GET">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Class<span class="text-danger">*</span></label>
                                        <select name="klass" data-url="<?= esc(route('section.select')) ?>?klass_id=" class="form-control custom-select klass-field">
                                            <?php if (! empty($currentklass)): ?>
                                                <option value="<?= esc($currentklass->id) ?>"><?= esc($currentklass->name) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($klasses as $klass): ?>
                                                <option value="<?= esc($klass->id) ?>"><?= esc($klass->name) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Section<span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <select name="section" class="form-control custom-select ksection">
                                            <?php if (! empty($currentsection)): ?>
                                                <option value="<?= esc($currentsection->id) ?>"><?= esc($currentsection->name) ?></option>
                                            <?php endif ?>
                                                <option value="">Select Class First</option>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group pb-4">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary rounded form-control px-5" type="submit" id="collect-fee-btn">
                                    <i class="fa fa-filter"></i>&nbsp;Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if (! empty($getklass) && ! empty($getsection)): ?>
<div class="row">
    <div class="col-md-12">
        <form action="" method="POST" id="fee-collect-form" class="collect-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-money"></i> Student Fee Collection</div>
                </div>
                <div class="ibox-body">
                    <div class="row mb-2">
                        <div class="col-md-12">
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentklass) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5">Section <?= esc($currentsection) ?></span>
                        </div>
                    </div>
                    <table class="table table-bordered table-hover data-table" id="table" cellspacing="0" width="100%" >
                        <thead class="thead-light">
                            <tr>
                                <th>Student Photo</th>
                                <th>Student Name</th>
                                <th>Reg Number</th>
                                <th>Roll Number</th>
                                <th>Gender</th>
                                <th>Fee Group</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="student-table">
                            <?php foreach ($students as $student): ?>
                            <tr class="table-row">
                                <td><img src="<?= esc(source('image.student', $student->photo)) ?>" alt="student photo" style="height: 30px;"></td>
                                <td><?= esc($student) ?></td>
                                <td><?= esc($student->reg_num) ?></td>
                                <td><?= esc($student->roll_num) ?></td>
                                <td><?= esc($student->gender) ?></td>
                            	<?php $assigned = $student->fee_collections->filter(['session' => $getsession, 'and', 'term' => $getterm])->all() ?>
                                <td>
                            	<?php if ($assigned): ?>
                            		<?php foreach ($assigned as $fee): ?>
                            			<div class="m-b-5">> <?= esc($fee->fee_group->fee_type) ?></div>
                            		<?php endforeach ?>
                            	<?php else: ?>
                            		No fee assigned
                            	<?php endif ?>
                                </td>
                                <td>
                            	<?php if ($assigned): ?>
                            		<?php foreach ($assigned as $fee): ?>
                            			<?php if ($fee->status == 'pending'): ?>
                            				<div><span class="badge badge-danger m-b-5"><?= esc($fee->status) ?></span></div>
                            			<?php elseif ($fee->status == 'part'): ?>
                            				<div><span class="badge badge-warning m-b-5"><?= esc($fee->status) ?></span></div>
                            			<?php elseif ($fee->status == 'part'): ?>
                            				<div><span class="badge badge-success m-b-5"><?= esc($fee->status) ?></span></div>
                            			<?php endif ?>
                            		<?php endforeach ?>
                            	<?php else: ?>
                            		No fee assigned
                            	<?php endif ?>
                                </td>
                                <td>
                                    <a href="<?= esc(route('fee.collect', [$student->id])) ?>" class="btn btn-default btn-xs m-r-5" title="View">
                                        <i class="fa fa-check-square font-14"></i> Collect
                                    </a>
                                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#sect-del-<?//= esc($club->id) ?>" title="Delete"><i class="fa fa-trash font-14"></i></button>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif ?>
<?php endsection() ?>